/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.text.MessageFormat;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.instance.RequestInfoInstanceList;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.jbpm.ExecutorServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/jobs")
public class ExecutorResource {
    public static final Logger logger = LoggerFactory.getLogger(ExecutorResource.class);
    private ExecutorServiceBase executorServiceBase;

    public ExecutorResource() {
    }

    public ExecutorResource(ExecutorServiceBase executorServiceBase) {
        this.executorServiceBase = executorServiceBase;
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response scheduleRequest(@Context HttpHeaders headers, @QueryParam(value="containerId") String containerId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.executorServiceBase.scheduleRequest(containerId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="{jobId}")
    @Produces(value={"application/xml", "application/json"})
    public Response cancelRequest(@Context HttpHeaders headers, @PathParam(value="jobId") long requestId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.executorServiceBase.cancelRequest(requestId);
            return null;
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{jobId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response requeueRequest(@Context HttpHeaders headers, @PathParam(value="jobId") long requestId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.executorServiceBase.requeueRequest(requestId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getRequestsByStatus(@Context HttpHeaders headers, @QueryParam(value="status") List<String> statuses, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            RequestInfoInstanceList result = this.executorServiceBase.getRequestsByStatus(statuses, page, pageSize);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="keys/{key}")
    @Produces(value={"application/xml", "application/json"})
    public Response getRequestsByBusinessKey(@Context HttpHeaders headers, @PathParam(value="key") String businessKey, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            RequestInfoInstanceList result = this.executorServiceBase.getRequestsByBusinessKey(businessKey, page, pageSize);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="commands/{cmd}")
    @Produces(value={"application/xml", "application/json"})
    public Response getRequestsByCommand(@Context HttpHeaders headers, @PathParam(value="cmd") String command, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            RequestInfoInstanceList result = this.executorServiceBase.getRequestsByCommand(command, page, pageSize);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{jobId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getRequestById(@Context HttpHeaders headers, @PathParam(value="jobId") Long requestId, @QueryParam(value="withErrors") boolean withErrors, @QueryParam(value="withData") boolean withData) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            String response = this.executorServiceBase.getRequestById(requestId.longValue(), withErrors, withData, type);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }
}

