/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.admin;

import java.text.MessageFormat;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.NodeInstanceNotFoundException;
import org.jbpm.services.api.NodeNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.kie.server.api.model.admin.MigrationReportInstance;
import org.kie.server.api.model.admin.MigrationReportInstanceList;
import org.kie.server.api.model.admin.ProcessNodeList;
import org.kie.server.api.model.admin.TimerInstanceList;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.admin.ProcessAdminServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/admin/containers/{id}/processes")
public class ProcessAdminResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAdminResource.class);
    private ProcessAdminServiceBase processAdminServiceBase;
    private KieServerRegistry context;

    public ProcessAdminResource() {
    }

    public ProcessAdminResource(ProcessAdminServiceBase processAdminServiceBase, KieServerRegistry context) {
        this.processAdminServiceBase = processAdminServiceBase;
        this.context = context;
    }

    @PUT
    @Path(value="instances/{pInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response migrateProcessInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @QueryParam(value="targetContainerId") String targetContainerId, @QueryParam(value="targetProcessId") String targetProcessId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            MigrationReportInstance reportInstance = this.processAdminServiceBase.migrateProcessInstance(containerId, (Number)processInstanceId, targetContainerId, targetProcessId, payload, type);
            return RestUtils.createCorrectVariant((Object)reportInstance, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @PUT
    @Path(value="instances")
    @Produces(value={"application/xml", "application/json"})
    public Response migrateProcessInstances(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="pInstanceId") List<Long> processInstanceIds, @QueryParam(value="targetContainerId") String targetContainerId, @QueryParam(value="targetProcessId") String targetProcessId, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            MigrationReportInstanceList reportInstances = this.processAdminServiceBase.migrateProcessInstances(containerId, processInstanceIds, targetContainerId, targetProcessId, payload, type);
            return RestUtils.createCorrectVariant((Object)reportInstances, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceIds), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @DELETE
    @Path(value="instances/{pInstanceId}/nodeinstances/{nodeInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response cancelNodeInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="nodeInstanceId") Long nodeInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.cancelNodeInstance(containerId, (Number)processInstanceId, (Number)nodeInstanceId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", nodeInstanceId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @PUT
    @Path(value="instances/{pInstanceId}/nodeinstances/{nodeInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response retriggerNodeInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="nodeInstanceId") Long nodeInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.retriggerNodeInstance(containerId, (Number)processInstanceId, (Number)nodeInstanceId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", nodeInstanceId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @PUT
    @Path(value="instances/{pInstanceId}/timers/{timerId}")
    @Produces(value={"application/xml", "application/json"})
    public Response updateTimer(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="timerId") Long timerId, @QueryParam(value="relative") @DefaultValue(value="true") boolean relative, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.updateTimer(containerId, (Number)processInstanceId, (Number)timerId, relative, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find timer instance with id \"{0}\" within process instance with id \"{1}\"", timerId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @POST
    @Path(value="instances/{pInstanceId}/nodes/{nodeId}")
    @Produces(value={"application/xml", "application/json"})
    public Response triggerNode(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="nodeId") Long nodeId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.triggerNode(containerId, (Number)processInstanceId, (Number)nodeId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node with id \"{0}\" within process instance with id \"{1}\"", nodeId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="instances/{pInstanceId}/timers")
    @Produces(value={"application/xml", "application/json"})
    public Response getTimerInstances(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TimerInstanceList timerInstanceList = this.processAdminServiceBase.getTimerInstances(containerId, (Number)processInstanceId);
            return RestUtils.createCorrectVariant((Object)timerInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="instances/{pInstanceId}/nodeinstances")
    @Produces(value={"application/xml", "application/json"})
    public Response getActiveNodeInstances(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            NodeInstanceList nodeInstanceList = this.processAdminServiceBase.getActiveNodeInstances(containerId, (Number)processInstanceId);
            return RestUtils.createCorrectVariant((Object)nodeInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="instances/{pInstanceId}/nodes")
    @Produces(value={"application/xml", "application/json"})
    public Response getNodes(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ProcessNodeList processNodeList = this.processAdminServiceBase.getProcessNodes(containerId, (Number)processInstanceId);
            return RestUtils.createCorrectVariant((Object)processNodeList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

