/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.server.api.model.instance.TaskAttachment;
import org.kie.server.api.model.instance.TaskAttachmentList;
import org.kie.server.api.model.instance.TaskComment;
import org.kie.server.api.model.instance.TaskCommentList;
import org.kie.server.api.model.instance.TaskEventInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.kie.server.services.jbpm.UserTaskServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Task instances")
@Path(value="server/containers/{containerId}/tasks")
public class UserTaskResource {
    public static final Logger logger = LoggerFactory.getLogger(UserTaskResource.class);
    private UserTaskServiceBase userTaskServiceBase;
    private RuntimeDataServiceBase runtimeDataServiceBase;
    private KieServerRegistry context;

    public UserTaskResource() {
    }

    public UserTaskResource(UserTaskServiceBase userTaskServiceBase, RuntimeDataServiceBase runtimeDataServiceBase, KieServerRegistry context) {
        this.userTaskServiceBase = userTaskServiceBase;
        this.runtimeDataServiceBase = runtimeDataServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Activates a specified task instance to be progressed.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/states/activated")
    @Produces(value={"application/json", "application/xml"})
    public Response activate(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be activated", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.activate(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Claims (reserves) a specified task instance for the user sending the request.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=403, message="User was unable to execute current operation on task with given id due to a no 'current status' match or insufficient permissions")})
    @PUT
    @Path(value="{taskInstanceId}/states/claimed")
    @Produces(value={"application/json", "application/xml"})
    public Response claim(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be claimed", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.claim(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (PermissionDeniedException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Completes a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=403, message="User was unable to execute current operation on task with given id due to a no 'current status' match or insufficient permissions")})
    @PUT
    @Path(value="{taskInstanceId}/states/completed")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response complete(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be completed", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional flag that allows to directlu claim and start task (if needed) before completion", required=false) @QueryParam(value="auto-progress") boolean autoProgress, @ApiParam(value="optional map of output variables", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            if (autoProgress) {
                this.userTaskServiceBase.completeAutoProgress(containerId, (Number)taskId, userId, payload, type);
            } else {
                this.userTaskServiceBase.complete(containerId, (Number)taskId, userId, payload, type);
            }
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (PermissionDeniedException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Delegates a specified task instance to a specified target user as the new task owner.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=403, message="User was unable to execute current operation on task with given id due to a no 'current status' match or insufficient permissions")})
    @PUT
    @Path(value="{taskInstanceId}/states/delegated")
    @Produces(value={"application/json", "application/xml"})
    public Response delegate(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be delegated", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="user that task should be dalegated to", required=true) @QueryParam(value="targetUser") String targetUserId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.delegate(containerId, (Number)taskId, userId, targetUserId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (PermissionDeniedException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Exits a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/states/exited")
    @Produces(value={"application/json", "application/xml"})
    public Response exit(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be exited", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.exit(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Fails a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/states/failed")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response fail(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be failed", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional map of output variables", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.fail(containerId, (Number)taskId, userId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Forwards a specified task instance to a specified target user for review or for suggested delegation.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=403, message="User was unable to execute current operation on task with given id due to a no 'current status' match or insufficient permissions")})
    @PUT
    @Path(value="{taskInstanceId}/states/forwarded")
    @Produces(value={"application/json", "application/xml"})
    public Response forward(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be forwarded", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="user that the task should be forwarded to", required=true) @QueryParam(value="targetUser") String targetUserId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.forward(containerId, (Number)taskId, userId, targetUserId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (PermissionDeniedException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Releases a specified task instance from being claimed by the task owner.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=403, message="User was unable to execute current operation on task with given id due to a no 'current status' match or insufficient permissions")})
    @PUT
    @Path(value="{taskInstanceId}/states/released")
    @Produces(value={"application/json", "application/xml"})
    public Response release(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be released", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.release(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (PermissionDeniedException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Resumes a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/states/resumed")
    @Produces(value={"application/json", "application/xml"})
    public Response resume(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be resumed", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.resume(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Skips a specified task instance within the sequence of tasks in the process instance", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/states/skipped")
    @Produces(value={"application/json", "application/xml"})
    public Response skip(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be skipped", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.skip(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Starts a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/states/started")
    @Produces(value={"application/json", "application/xml"})
    public Response start(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be started", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.start(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Stops a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/states/stopped")
    @Produces(value={"application/json", "application/xml"})
    public Response stop(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be stopped", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.stop(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Suspends a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/states/suspended")
    @Produces(value={"application/json", "application/xml"})
    public Response suspend(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be suspended", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.suspend(containerId, (Number)taskId, userId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Nominates one or more potential owners to whom the task instance should be assigned.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=403, message="User was unable to execute current operation on task with given id due to a no 'current status' match or insufficient permissions")})
    @PUT
    @Path(value="{taskInstanceId}/states/nominated")
    @Produces(value={"application/json", "application/xml"})
    public Response nominate(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be nominated", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="list of users that the task should be nominated to", required=true) @QueryParam(value="potOwner") List<String> potentialOwners) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.nominate(containerId, (Number)taskId, userId, potentialOwners);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (PermissionDeniedException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates the priority of a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/priority")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response setPriority(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance where priority should be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="priority as Integer", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="10"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<int-type>\n    <value>10</value>\n</int-type>")})) String priorityPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setPriority(containerId, (Number)taskId, priorityPayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates the expiration date for a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/expiration")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response setExpirationDate(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance where expiration date should be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="expiration date as Date", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"java.util.Date\" : 1540025263987\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<date-type>\n    <value>2018-10-20T10:47:43.607+02:00</value>\n</date-type>")})) String datePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setExpirationDate(containerId, (Number)taskId, datePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Marks a specified task instance that can be skipped in a sequence of tasks.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/skipable")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response setSkipable(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance where skipable flag should be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="skipable flag as Boolean", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="false"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<boolean-type>\n    <value>false</value>\n</boolean-type>")})) String skipablePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setSkipable(containerId, (Number)taskId, skipablePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates the name of a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/name")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response setName(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance where name should be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="name as String", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="\"Simple user task.\""), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<string-type>\n    <value>Simple user task.</value>\n</string-type>")})) String namePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setName(containerId, (Number)taskId, namePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates the description of a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/description")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response setDescription(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance where description should be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="description as String", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="\"Simple user task.\""), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<string-type>\n    <value>Simple user task.</value>\n</string-type>")})) String descriptionPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.setDescription(containerId, (Number)taskId, descriptionPayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Adds output data to a specified task instance and returns the ID of the new output content.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=403, message="User is not allowed to perform the operation"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}/contents/output")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response saveContent(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that data should be saved into", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="output data to be saved as Map ", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.saveContent(containerId, (Number)taskId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (PermissionDeniedException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns output data for a specified task instance.", response=Map.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"application\": {\n    \"com.myspace.mortgage_app.Application\": {\n      \"applicant\": {\n        \"com.myspace.mortgage_app.Applicant\": {\n          \"name\": \"\",\n          \"annualincome\": 0,\n          \"address\": null,\n          \"ssn\": 0,\n          \"creditrating\": null\n        }\n      },\n      \"property\": {\n        \"com.myspace.mortgage_app.Property\": {\n          \"age\": 0,\n          \"address\": \"\",\n          \"locale\": \"\",\n          \"saleprice\": 0\n        }\n      },\n      \"downpayment\": 0,\n      \"amortization\": 0,\n      \"mortgageamount\": null\n    }\n  },\n  \"initiator\": \"baAdmin\"\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/contents/output")
    @Produces(value={"application/json", "application/xml"})
    public Response getTaskOutputContentByTaskId(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that output data should be loaded from", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getTaskOutputContentByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns input data for a specified task instance.", response=Map.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"application\": {\n    \"com.myspace.mortgage_app.Application\": {\n      \"applicant\": {\n        \"com.myspace.mortgage_app.Applicant\": {\n          \"name\": \"\",\n          \"annualincome\": 0,\n          \"address\": null,\n          \"ssn\": 0,\n          \"creditrating\": null\n        }\n      },\n      \"property\": {\n        \"com.myspace.mortgage_app.Property\": {\n          \"age\": 0,\n          \"address\": \"\",\n          \"locale\": \"\",\n          \"saleprice\": 0\n        }\n      },\n      \"downpayment\": 0,\n      \"amortization\": 0,\n      \"mortgageamount\": null\n    }\n  },\n  \"initiator\": \"baAdmin\"\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/contents/input")
    @Produces(value={"application/json", "application/xml"})
    public Response getTaskInputContentByTaskId(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that input data should be loaded from", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getTaskInputContentByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes output data by content ID from a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/contents/{contentId}")
    @Produces(value={"application/json", "application/xml"})
    public Response deleteContent(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that content belongs to", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="identifier of the content to be deleted", required=true, example="567") @PathParam(value="contentId") Long contentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.deleteContent(containerId, (Number)taskId, (Number)contentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Adds a comment to a specified task instance and returns the ID of the new comment.", response=Long.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="10")}))})
    @POST
    @Path(value="{taskInstanceId}/comments")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addComment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that comment should be added to", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="comment data as TaskComment", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"comment-id\" : null,\n  \"comment\" : \"First comment.\",\n  \"comment-added-by\" : \"yoda\",\n  \"comment-added-at\" : {\n    \"java.util.Date\" : 1539939094774\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<task-comment>\n    <comment>First comment.</comment>\n    <comment-added-by>yoda</comment-added-by>\n    <comment-added-at>2018-10-19T10:51:34.405+02:00</comment-added-at>\n</task-comment>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.addComment(containerId, (Number)taskId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes a specified comment from a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/comments/{commentId}")
    @Produces(value={"application/json", "application/xml"})
    public Response deleteComment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that comment belongs to", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="identifier of the comment to be deleted", required=true, example="567") @PathParam(value="commentId") Long commentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.deleteComment(containerId, (Number)taskId, (Number)commentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all comments in a specified task instance.", response=TaskCommentList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-comment\": [\n    {\n      \"comment-id\": 1,\n      \"comment\": \"Ensure that this self evaluation is completed before the HR and PM evaluations.\",\n      \"comment-added-by\": \"baAdmin\",\n      \"comment-added-at\": {\n        \"java.util.Date\": 1540238822132\n      }\n    },\n    {\n      \"comment-id\": 2,\n      \"comment\": \"Task must be assigned to administrator.\",\n      \"comment-added-by\": \"baAdmin\",\n      \"comment-added-at\": {\n        \"java.util.Date\": 1540238822140\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/comments")
    @Produces(value={"application/json", "application/xml"})
    public Response getCommentsByTaskId(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that comments should be loaded for", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getCommentsByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns a specified comment from a specified task instance.", response=TaskComment.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"comment-id\" : null,\n  \"comment\" : \"First comment.\",\n  \"comment-added-by\" : \"yoda\",\n  \"comment-added-at\" : {\n    \"java.util.Date\" : 1539939094774\n  }\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/comments/{commentId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getCommentById(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that comment belongs to", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="identifier of the comment to be loaded", required=true, example="567") @PathParam(value="commentId") Long commentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getCommentById(containerId, (Number)taskId, (Number)commentId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Adds an attachment to a specified task instance and returns the ID of the new attachment.", response=Long.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=201, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="10")}))})
    @POST
    @Path(value="{taskInstanceId}/attachments")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addAttachment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that attachment should be added to", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="name of the attachment to be added", required=true) @QueryParam(value="name") String name, @ApiParam(value="attachment content, any type can be provided", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"Person\": {\n        \"name\": \"john\"\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<person>\n    <name>john</name>\n</person>")})) String attachmentPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.addAttachment(containerId, (Number)taskId, userId, name, attachmentPayload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes a specified attachment from a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/attachments/{attachmentId}")
    @Produces(value={"application/json", "application/xml"})
    public Response deleteAttachment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that attachment belongs to", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="identifier of the attachment to be deleted", required=true, example="567") @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.deleteAttachment(containerId, (Number)taskId, (Number)attachmentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a specified attachment for a specified task instance.", response=TaskAttachment.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"Person\": {\n        \"name\": \"john\"\n    }\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/attachments/{attachmentId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getAttachmentById(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that attachment belongs to", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="identifier of the attachment to be loaded", required=true, example="567") @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getAttachmentById(containerId, (Number)taskId, (Number)attachmentId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns the content of a specified attachment for a specified task instance.", response=Object.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"Person\": {\n        \"name\": \"john\"\n    }\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/attachments/{attachmentId}/content")
    @Produces(value={"application/json", "application/xml"})
    public Response getAttachmentContentById(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that attachment belongs to", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="identifier of the attachment that content should be loaded from", required=true, example="567") @PathParam(value="attachmentId") Long attachmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getAttachmentContentById(containerId, (Number)taskId, (Number)attachmentId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all attachments for a specified task instance.", response=TaskAttachmentList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-attachment\": [\n    {\n      \"attachment-id\": 1,\n      \"attachment-name\": \"Task Attachment\",\n      \"attachment-added-by\": \"baAdmin\",\n      \"attachment-added-at\": {\n        \"java.util.Date\": 1540229715779\n      },\n      \"attachment-type\": \"java.util.LinkedHashMap\",\n      \"attachment-size\": 233,\n      \"attachment-content-id\": 31\n    },\n    {\n      \"attachment-id\": 2,\n      \"attachment-name\": \"Task Attachment 2\",\n      \"attachment-added-by\": \"baAdmin\",\n      \"attachment-added-at\": {\n        \"java.util.Date\": 1540229715780\n      },\n      \"attachment-type\": \"java.util.LinkedHashMap\",\n      \"attachment-size\": 300,\n      \"attachment-content-id\": 32\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/attachments")
    @Produces(value={"application/json", "application/xml"})
    public Response getAttachmentsByTaskId(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that attachments should be loaded for", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getAttachmentsByTaskId(containerId, (Number)taskId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a specified task instance.", response=TaskInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-id\": 1,\n  \"task-priority\": 0,\n  \"task-name\": \"Self Evaluation\",\n  \"task-subject\": null,\n  \"task-description\": \"Please perform a self-evalutation.\",\n  \"task-type\": null,\n  \"task-form\": null,\n  \"task-status\": \"Ready\",\n  \"task-actual-owner\": \"kiesu\",\n  \"task-created-by\": \"Jane\",\n  \"task-created-on\": {\n    \"java.util.Date\": 1539623679113\n  },\n  \"task-activation-time\": {\n    \"java.util.Date\": 1539623679113\n  },\n  \"task-expiration-time\": null,\n  \"task-skippable\": null,\n  \"task-workitem-id\": null,\n  \"task-process-instance-id\": 4,\n  \"task-parent-id\": null,\n  \"task-process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n  \"task-container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n  \"task-pot-owners\": \"Jane\",\n  \"task-excl-owners\": null,\n  \"task-business-admins\": \"John\",\n  \"task-input-data\": null,\n  \"task-output-data\": null\n}")}))})
    @GET
    @Path(value="{taskInstanceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getTask(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be loaded", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optionally loads task input data", required=false) @QueryParam(value="withInputData") boolean withInput, @ApiParam(value="optionally loads task output data", required=false) @QueryParam(value="withOutputData") boolean withOutput, @ApiParam(value="optionally loads task people assignments", required=false) @QueryParam(value="withAssignments") boolean withAssignments) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.userTaskServiceBase.getTask(containerId, (Number)taskId, withInput, withOutput, withAssignments, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all events for a specified task instance.", response=TaskEventInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-event-instance\": [\n    {\n      \"task-event-id\": 4,\n      \"task-id\": 4,\n      \"task-event-type\": \"STARTED\",\n      \"task-event-user\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"task-event-date\": {\n        \"java.util.Date\": 1539623679130\n      },\n      \"task-process-instance-id\": 4,\n      \"task-work-item-id\": 4,\n      \"task-event-message\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/events")
    @Produces(value={"application/json", "application/xml"})
    public Response getTaskEvents(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that events should be loaded for", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskEventInstanceList result = this.runtimeDataServiceBase.getTaskEvents(taskId.longValue(), page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates information in a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task with given id not found")})
    @PUT
    @Path(value="{taskInstanceId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response update(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that should be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="task instance with updates as TaskInstance type", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-id\" : null,\n  \"task-priority\" : 10,\n  \"task-name\" : \"Modified name\",\n  \"task-subject\" : null,\n  \"task-description\" : \"Simple user task.\",\n  \"task-type\" : null,\n  \"task-form\" : null,\n  \"task-status\" : null,\n  \"task-actual-owner\" : null,\n  \"task-created-by\" : null,\n  \"task-created-on\" : null,\n  \"task-activation-time\" : null,\n  \"task-expiration-time\" : {\n    \"java.util.Date\" : 1540025025627\n  },\n  \"task-skippable\" : null,\n  \"task-workitem-id\" : null,\n  \"task-process-instance-id\" : null,\n  \"task-parent-id\" : null,\n  \"task-process-id\" : null,\n  \"task-container-id\" : null,\n  \"task-pot-owners\" : null,\n  \"task-excl-owners\" : null,\n  \"task-business-admins\" : null,\n  \"task-input-data\" : {\n    \"added input\" : \"test\"\n  },\n  \"task-output-data\" : {\n    \"person_\" : {\n      \"org.jbpm.data.Person\" : {\n        \"name\" : \"mary\"\n      }\n    },\n    \"string_\" : \"my custom data\"\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<task-instance>\n    <task-priority>10</task-priority>\n    <task-name>Modified name</task-name>\n    <task-description>Simple user task.</task-description>\n    <task-expiration-time>2018-10-20T10:43:45.273+02:00</task-expiration-time>\n    <inputData>\n        <entry>\n            <key>added input</key>\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">test</value>\n        </entry>\n    </inputData>\n    <outputData>\n        <entry>\n            <key>person_</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>mary</name>\n            </value>\n        </entry>\n        <entry>\n            <key>string_</key>\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">my custom data</value>\n        </entry>\n    </outputData>\n</task-instance>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskServiceBase.update(containerId, (Number)taskId, userId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)RestUtils.errorMessage((Throwable)e, (String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId)), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

