/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URLDecoder;
import java.text.MessageFormat;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.definition.AssociatedEntitiesDefinition;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ServiceTasksDefinition;
import org.kie.server.api.model.definition.SubProcessesDefinition;
import org.kie.server.api.model.definition.TaskInputsDefinition;
import org.kie.server.api.model.definition.TaskOutputsDefinition;
import org.kie.server.api.model.definition.UserTaskDefinitionList;
import org.kie.server.api.model.definition.VariablesDefinition;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.DefinitionServiceBase;

@Api(value="Process and task definitions :: BPM")
@Path(value="server/containers/{id}/processes/definitions")
public class DefinitionResource {
    private DefinitionServiceBase definitionServiceBase;
    private KieServerRegistry context;

    public DefinitionResource() {
    }

    public DefinitionResource(DefinitionServiceBase definitionServiceBase, KieServerRegistry context) {
        this.definitionServiceBase = definitionServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Retrieves process definition identified by given process id within given container", response=ProcessDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process or Container Id not found")})
    @GET
    @Path(value="{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessDefinition(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="process id that the definition should be retrieved for", required=true) @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ProcessDefinition responseObject = this.definitionServiceBase.getProcessDefinition(containerId, processId);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves sub process definitions that are defined in given process within given container", response=SubProcessesDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process or Container Id not found")})
    @GET
    @Path(value="{pId}/subprocesses")
    @Produces(value={"application/xml", "application/json"})
    public Response getReusableSubProcesses(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="process id that subprocesses should be retrieved from", required=true) @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            SubProcessesDefinition definition = this.definitionServiceBase.getReusableSubProcesses(containerId, processId);
            return RestUtils.createCorrectVariant((Object)definition, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves process variables definitions that are present in given process and container", response=VariablesDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process or Container Id not found")})
    @GET
    @Path(value="{pId}/variables")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessVariables(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="process id that the variable definitions should be retrieved from", required=true) @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            VariablesDefinition variablesDefinition = this.definitionServiceBase.getProcessVariables(containerId, processId);
            return RestUtils.createCorrectVariant((Object)variablesDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves service tasks definitions that are present in given process and container", response=ServiceTasksDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process or Container Id not found")})
    @GET
    @Path(value="{pId}/tasks/service")
    @Produces(value={"application/xml", "application/json"})
    public Response getServiceTasks(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="process id that the service task definitions should be retrieved from", required=true) @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ServiceTasksDefinition serviceTasksDefinition = this.definitionServiceBase.getServiceTasks(containerId, processId);
            return RestUtils.createCorrectVariant((Object)serviceTasksDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves actors and groups that are involved in given process and container", response=AssociatedEntitiesDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process or Container Id not found")})
    @GET
    @Path(value="{pId}/entities")
    @Produces(value={"application/xml", "application/json"})
    public Response getAssociatedEntities(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="process id that the involved actors and groups should be retrieved from", required=true) @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            AssociatedEntitiesDefinition associatedEntitiesDefinition = this.definitionServiceBase.getAssociatedEntities(containerId, processId);
            return RestUtils.createCorrectVariant((Object)associatedEntitiesDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves user tasks definitions that are present in given process and container", response=UserTaskDefinitionList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process or Container Id not found")})
    @GET
    @Path(value="{pId}/tasks/users")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksDefinitions(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="process id that the user task definitions should be retrieved from", required=true) @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            UserTaskDefinitionList userTaskDefinitions = this.definitionServiceBase.getTasksDefinitions(containerId, processId);
            return RestUtils.createCorrectVariant((Object)userTaskDefinitions, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves input variables defined on a given user task", response=TaskInputsDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process or Container Id not found")})
    @GET
    @Path(value="{pId}/tasks/users/{taskName}/inputs")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskInputMappings(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="process id that given task belongs to", required=true) @PathParam(value="pId") String processId, @ApiParam(value="task name that input variable definitions should be retrieved for", required=true) @PathParam(value="taskName") String taskName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskInputsDefinition taskInputsDefinition = this.definitionServiceBase.getTaskInputMappings(containerId, processId, URLDecoder.decode(taskName, "UTF-8"));
            return RestUtils.createCorrectVariant((Object)taskInputsDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves output variables defined on a given user task", response=TaskOutputsDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process or Container Id not found")})
    @GET
    @Path(value="{pId}/tasks/users/{taskName}/outputs")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskOutputMappings(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true) @PathParam(value="id") String containerId, @ApiParam(value="process id that given task belongs to", required=true) @PathParam(value="pId") String processId, @ApiParam(value="task name that output variable definitions should be retrieved for", required=true) @PathParam(value="taskName") String taskName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskOutputsDefinition taskOutputsDefinition = this.definitionServiceBase.getTaskOutputMappings(containerId, processId, URLDecoder.decode(taskName, "UTF-8"));
            return RestUtils.createCorrectVariant((Object)taskOutputsDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

