/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.mail.internet.MimeUtility;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.instance.DocumentInstance;
import org.kie.server.api.model.instance.DocumentInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieServerRuntimeException;
import org.kie.server.services.jbpm.DocumentServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Documents :: BPM")
@Path(value="server/documents")
public class DocumentResource {
    public static final Logger logger = LoggerFactory.getLogger(DocumentResource.class);
    private DocumentServiceBase documentServiceBase;
    private KieServerRegistry context;

    public DocumentResource() {
    }

    public DocumentResource(DocumentServiceBase documentServiceBase, KieServerRegistry context) {
        this.documentServiceBase = documentServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Retrieves document's content identified by given documentId", response=byte[].class, code=200, responseHeaders={@ResponseHeader(name="Content-Disposition", description="provides file name of the document")})
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Document with given id not found")})
    @GET
    @Path(value="{documentId}/content")
    @Produces(value={"application/octet-stream"})
    public Response getDocumentContent(@Context HttpHeaders headers, @ApiParam(value="document id of a document that content should be retruned from", required=true) @PathParam(value="documentId") String documentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            final DocumentInstance document = this.documentServiceBase.getDocument(documentId);
            if (document == null) {
                return RestUtils.notFound((String)("Document with id " + documentId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            String fileName = MimeUtility.encodeWord((String)document.getName(), (String)"utf-8", (String)"Q");
            StreamingOutput entity = new StreamingOutput(){

                public void write(OutputStream output) throws IOException, WebApplicationException {
                    output.write(document.getContent());
                }
            };
            if (conversationIdHeader != null) {
                return Response.ok().entity((Object)entity).header(conversationIdHeader.getName(), (Object)conversationIdHeader.getValue()).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).build();
            }
            return Response.ok().entity((Object)entity).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).build();
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves document identified by given documentId", response=DocumentInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Document with given id not found")})
    @GET
    @Path(value="{documentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getDocument(@Context HttpHeaders headers, @ApiParam(value="document id of a document that should be retruned", required=true) @PathParam(value="documentId") String documentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            DocumentInstance document = this.documentServiceBase.getDocument(documentId);
            return RestUtils.createCorrectVariant((Object)document, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (KieServerRuntimeException e) {
            return RestUtils.notFound((String)("Document with id " + documentId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves documents that are stored in the system, with pagination", response=DocumentInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response listDocuments(@Context HttpHeaders headers, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            DocumentInstanceList documents = this.documentServiceBase.listDocuments(page, pageSize);
            return RestUtils.createCorrectVariant((Object)documents, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Creates new document based on given content (body)", response=String.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response createDocument(@Context HttpHeaders headers, @ApiParam(value="document content represented as DocumentInstance", required=true, type="DocumentInstance") String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String identifier = this.documentServiceBase.storeDocument(payload, type);
            return RestUtils.createCorrectVariant((Object)identifier, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates document identified by given document id based on given content (body)", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Document with given id not found")})
    @PUT
    @Path(value="{documentId}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response updateDocument(@Context HttpHeaders headers, @ApiParam(value="document id of a document that should be updated", required=true) @PathParam(value="documentId") String documentId, @ApiParam(value="document content represented as DocumentInstance", required=true, type="DocumentInstance") String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.documentServiceBase.updateDocument(documentId, payload, type);
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (KieServerRuntimeException e) {
            return RestUtils.notFound((String)("Document with id " + documentId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes document identified by given document id", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Document with given id not found")})
    @DELETE
    @Path(value="{documentId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteDocument(@Context HttpHeaders headers, @ApiParam(value="document id of a document that should be deleted", required=true) @PathParam(value="documentId") String documentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.documentServiceBase.deleteDocument(documentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (KieServerRuntimeException e) {
            return RestUtils.notFound((String)("Document with id " + documentId + " not found"), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

