/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.client;

import java.util.Arrays;
import java.util.List;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatusFilter;
import org.kie.server.api.model.ReleaseIdFilter;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.common.rest.KieServerHttpRequest;
import org.kie.server.common.rest.KieServerHttpResponse;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerRouterEventListener
implements KieServerEventListener {
    private static final Logger logger = LoggerFactory.getLogger(KieServerRouterEventListener.class);
    private String serverId = System.getProperty("org.kie.server.id");
    private String serverURL = System.getProperty("org.kie.server.location");
    private String routerURL = System.getProperty("org.kie.server.router");
    private KieContainerResourceFilter activeOnly = new KieContainerResourceFilter(ReleaseIdFilter.ACCEPT_ALL, KieContainerStatusFilter.parseFromNullableString((String)"STARTED"));

    public void beforeServerStarted(KieServer kieServer) {
    }

    public void afterServerStarted(KieServer kieServer) {
    }

    public void beforeServerStopped(KieServer kieServer) {
        if (this.routerURL == null) {
            logger.debug("KieServer router url not given, skipping");
            return;
        }
        ServiceResponse containers = kieServer.listContainers(this.activeOnly);
        ((KieContainerResourceList)containers.getResult()).getContainers().forEach(ci -> this.routers().forEach(url -> {
            boolean success = this.send(url + "/admin/remove", ci.getContainerId());
            if (success) {
                logger.info("Removed '{}' as server location for container id '{}'", (Object)this.serverURL, (Object)ci.getContainerId());
            }
            String alias = this.getContainerAlias((KieContainerResource)ci);
            success = this.send(url + "/admin/remove", alias);
            if (success) {
                logger.info("Removed '{}' as server location for container alias '{}'", (Object)this.serverURL, (Object)alias);
            }
        }));
    }

    public void afterServerStopped(KieServer kieServer) {
    }

    public void beforeContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
        if (this.routerURL == null) {
            logger.debug("KieServer router url not given, skipping");
            return;
        }
        this.routers().forEach(url -> {
            boolean success = this.send(url + "/admin/add", containerInstance.getContainerId());
            if (success) {
                logger.info("Added '{}' as server location for container id '{}'", (Object)this.serverURL, (Object)containerInstance.getContainerId());
            }
            String alias = this.getContainerAlias(containerInstance.getResource());
            success = this.send(url + "/admin/add", alias);
            if (success) {
                logger.info("Added '{}' as server location for container alias '{}'", (Object)this.serverURL, (Object)alias);
            }
        });
    }

    public void beforeContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
        if (this.routerURL == null) {
            logger.debug("KieServer router url not given, skipping");
            return;
        }
        this.routers().forEach(url -> {
            boolean success = this.send(url + "/admin/remove", containerInstance.getContainerId());
            if (success) {
                logger.info("Removed '{}' as server location for container id '{}'", (Object)this.serverURL, (Object)containerInstance.getContainerId());
            }
            String alias = this.getContainerAlias(containerInstance.getResource());
            success = this.send(url + "/admin/remove", alias);
            if (success) {
                logger.info("Removed '{}' as server location for container alias '{}'", (Object)this.serverURL, (Object)alias);
            }
        });
    }

    protected boolean send(String url, String containerId) {
        String jsonBody = "{\"containerId\" : \"" + containerId + "\",\"serverUrl\" : \"" + this.serverURL + "\",\"serverId\" : \"" + this.serverId + "\",}";
        try {
            KieServerHttpRequest httpRequest = KieServerHttpRequest.newRequest((String)url).followRedirects(true).timeout(5000L).body((CharSequence)jsonBody).post();
            KieServerHttpResponse response = httpRequest.response();
            logger.debug("Response for url {} is {}", (Object)httpRequest.getUrl(), (Object)response.code());
            return true;
        }
        catch (Exception e) {
            logger.warn("Failed at sending request to router at {} due to {}", (Object)url, (Object)this.findCause(e).getMessage());
            logger.debug("Send to router failed", (Throwable)e);
            return false;
        }
    }

    protected String getContainerAlias(KieContainerResource containerInstance) {
        String alias = containerInstance.getContainerAlias();
        if (alias == null || alias.isEmpty()) {
            alias = containerInstance.getReleaseId().getArtifactId();
        }
        return alias;
    }

    protected List<String> routers() {
        return Arrays.asList(this.routerURL.split(","));
    }

    protected Throwable findCause(Exception e) {
        Throwable found = e;
        while (found.getCause() != null) {
            found = found.getCause();
        }
        return found;
    }
}

