/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.client;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatusFilter;
import org.kie.server.api.model.ReleaseIdFilter;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.common.rest.KieServerHttpRequest;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.kie.server.common.rest.KieServerHttpResponse;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerRouterEventListener
implements KieServerEventListener {
    private static final Logger logger = LoggerFactory.getLogger(KieServerRouterEventListener.class);
    private String serverId = System.getProperty("org.kie.server.id");
    private String serverURL = System.getProperty("org.kie.server.location");
    private String routerURL = System.getProperty("org.kie.server.router");
    private int failedAttemptsInterval = Integer.parseInt(System.getProperty("org.kie.server.router.connect", "10"));
    private KieContainerResourceFilter activeOnly = new KieContainerResourceFilter(ReleaseIdFilter.ACCEPT_ALL, KieContainerStatusFilter.parseFromNullableString((String)"STARTED"));
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private RouterConnectionObserver observer = new RouterConnectionObserver();
    private String CONTAINER_ID_JSON = "\"containerId\" : \"{0}\",\"serverUrl\" : \"{1}\",\"serverId\" : \"{2}\",\"releaseId\" : \"{3}\"";
    private String CONTAINER_ALIAS_JSON = "\"containerId\" : \"{0}\",\"serverUrl\" : \"{1}\",\"serverId\" : \"{2}\"";

    public KieServerRouterEventListener() {
    }

    public KieServerRouterEventListener(String serverId, String serverURL, String routerURL, int failedAttemptsInterval) {
        this.serverId = serverId;
        this.serverURL = serverURL;
        this.routerURL = routerURL;
        this.failedAttemptsInterval = failedAttemptsInterval;
    }

    public void beforeServerStarted(KieServer kieServer) {
    }

    public void afterServerStarted(KieServer kieServer) {
    }

    public void beforeServerStopped(KieServer kieServer) {
        if (this.routerURL == null) {
            logger.debug("KieServer router url not given, skipping");
            return;
        }
        ServiceResponse containers = kieServer.listContainers(this.activeOnly);
        ((KieContainerResourceList)containers.getResult()).getContainers().forEach(ci -> this.routers().forEach(url -> {
            String containerIdPayload = "{" + MessageFormat.format(this.CONTAINER_ID_JSON, ci.getContainerId(), this.serverURL, this.serverId, ci.getReleaseId().toExternalForm()) + "}";
            boolean success = this.send(url + "/admin/remove", ci.getContainerId(), containerIdPayload, false, false);
            if (success) {
                logger.info("Removed '{}' as server location for container id '{}'", (Object)this.serverURL, (Object)ci.getContainerId());
            }
            String alias = this.getContainerAlias((KieContainerResource)ci);
            String containerAliasPayload = "{" + MessageFormat.format(this.CONTAINER_ALIAS_JSON, alias, this.serverURL, this.serverId) + "}";
            success = this.send(url + "/admin/remove", alias, containerAliasPayload, false, false);
            if (success) {
                logger.info("Removed '{}' as server location for container alias '{}'", (Object)this.serverURL, (Object)alias);
            }
        }));
    }

    public void afterServerStopped(KieServer kieServer) {
        this.close();
    }

    public void beforeContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
        if (this.routerURL == null) {
            logger.debug("KieServer router url not given, skipping");
            return;
        }
        this.routers().forEach(url -> {
            String containerIdPayload = "{" + MessageFormat.format(this.CONTAINER_ID_JSON, containerInstance.getContainerId(), this.serverURL, this.serverId, containerInstance.getResource().getReleaseId().toExternalForm()) + "}";
            boolean success = this.send(url + "/admin/add", containerInstance.getContainerId(), containerIdPayload, true, true);
            if (success) {
                logger.info("Added '{}' as server location for container id '{}'", (Object)this.serverURL, (Object)containerInstance.getContainerId());
            }
            String alias = this.getContainerAlias(containerInstance.getResource());
            String containerAliasPayload = "{" + MessageFormat.format(this.CONTAINER_ALIAS_JSON, alias, this.serverURL, this.serverId) + "}";
            success = this.send(url + "/admin/add", alias, containerAliasPayload, true, true);
            if (success) {
                logger.info("Added '{}' as server location for container alias '{}'", (Object)this.serverURL, (Object)alias);
            }
        });
    }

    public void beforeContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
        if (this.routerURL == null) {
            logger.debug("KieServer router url not given, skipping");
            return;
        }
        this.routers().forEach(url -> {
            String containerIdPayload = "{" + MessageFormat.format(this.CONTAINER_ID_JSON, containerInstance.getContainerId(), this.serverURL, this.serverId, containerInstance.getResource().getReleaseId().toExternalForm()) + "}";
            boolean success = this.send(url + "/admin/remove", containerInstance.getContainerId(), containerIdPayload, false, true);
            if (success) {
                logger.info("Removed '{}' as server location for container id '{}'", (Object)this.serverURL, (Object)containerInstance.getContainerId());
            }
            String alias = this.getContainerAlias(containerInstance.getResource());
            String containerAliasPayload = "{" + MessageFormat.format(this.CONTAINER_ALIAS_JSON, alias, this.serverURL, this.serverId) + "}";
            success = this.send(url + "/admin/remove", alias, containerAliasPayload, false, true);
            if (success) {
                logger.info("Removed '{}' as server location for container alias '{}'", (Object)this.serverURL, (Object)alias);
            }
        });
    }

    protected boolean send(String url, String containerId, String payload, boolean add, boolean retry) {
        try {
            KieServerHttpRequest httpRequest = KieServerHttpRequest.newRequest((String)url).followRedirects(true).contentType("application/json").accept("application/json").timeout(5000L).body((CharSequence)payload).post();
            KieServerHttpResponse response = httpRequest.response();
            int responseCode = response.code();
            logger.debug("Response for url {} is {}", (Object)httpRequest.getUrl(), (Object)responseCode);
            if (responseCode > 201) {
                throw new KieServerHttpRequestException("Connection error " + responseCode);
            }
            this.observer.onSuccess(url);
            return true;
        }
        catch (KieServerHttpRequestException ioe) {
            logger.debug("Send to router failed", (Throwable)ioe);
            if (retry) {
                this.executorService.schedule(() -> {
                    boolean success = this.send(url, containerId, payload, add, true);
                    if (success) {
                        if (add) {
                            logger.info("Added '{}' as server location for container '{}'", (Object)this.serverURL, (Object)containerId);
                        } else {
                            logger.info("Removed '{}' as server location for container '{}'", (Object)this.serverURL, (Object)containerId);
                        }
                    }
                }, (long)this.failedAttemptsInterval, TimeUnit.SECONDS);
                logger.warn("Failed at sending request to router at {} due to {}. Next attempt is scheduled to fire in {} seconds", new Object[]{url, this.findCause((Exception)((Object)ioe)).getMessage(), this.failedAttemptsInterval});
            } else {
                logger.warn("Failed at sending request to router at {} due to {}.", (Object)url, (Object)this.findCause((Exception)((Object)ioe)).getMessage());
            }
            this.observer.onFailure(url);
            return false;
        }
        catch (Exception e) {
            logger.warn("Failed at sending request to router at {} due to {}", (Object)url, (Object)this.findCause(e).getMessage());
            logger.debug("Send to router failed", (Throwable)e);
            return false;
        }
    }

    protected String getContainerAlias(KieContainerResource containerInstance) {
        String alias = containerInstance.getContainerAlias();
        if (alias == null || alias.isEmpty()) {
            alias = containerInstance.getReleaseId().getArtifactId();
        }
        return alias;
    }

    protected List<String> routers() {
        String[] routerUrls;
        ArrayList<String> list = new ArrayList<String>();
        for (String routerUrl : routerUrls = this.routerURL.split(",")) {
            if ((routerUrl = routerUrl.trim()).endsWith("/")) {
                routerUrl = routerUrl.substring(0, routerUrl.length() - 1);
            }
            list.add(routerUrl);
        }
        return list;
    }

    protected Throwable findCause(Exception e) {
        Throwable found = e;
        while (found.getCause() != null) {
            found = found.getCause();
        }
        return found;
    }

    public RouterConnectionObserver getObserver() {
        return this.observer;
    }

    public void setObserver(RouterConnectionObserver observer) {
        this.observer = observer;
    }

    public void close() {
        logger.debug("About to shutdown internal executor service to handle failed attempts when connecting to kie server router...");
        this.executorService.shutdownNow();
        logger.debug("Internal executor service to handle failed attempts when connecting to kie server router stopped successfully");
    }

    public static class RouterConnectionObserver {
        public void onSuccess(String url) {
        }

        public void onFailure(String url) {
        }
    }
}

