/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.client;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.router.client.KieServerRouterEventListener;

public class KieServerRouterEventListenerTest {
    @After
    public void cleanup() {
        System.clearProperty("org.kie.server.router");
    }

    @Test
    public void testRouterUrlsWithSlashAtTheEnd() {
        System.setProperty("org.kie.server.router", "http://localhost:9000/,http://localhost:9001/, http://localhost:9002/");
        KieServerRouterEventListener client = new KieServerRouterEventListener();
        List routerUrls = client.routers();
        Assert.assertNotNull((Object)routerUrls);
        Assert.assertEquals((long)3L, (long)routerUrls.size());
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9000"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9001"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9002"));
    }

    @Test
    public void testRouterUrlsWithoutSlashAtTheEnd() {
        System.setProperty("org.kie.server.router", "http://localhost:9000,http://localhost:9001, http://localhost:9002");
        KieServerRouterEventListener client = new KieServerRouterEventListener();
        List routerUrls = client.routers();
        Assert.assertNotNull((Object)routerUrls);
        Assert.assertEquals((long)3L, (long)routerUrls.size());
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9000"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9001"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9002"));
    }

    @Test
    public void testRouterUrlsWithAndWithoutSlashAtTheEnd() {
        System.setProperty("org.kie.server.router", "http://localhost:9000,http://localhost:9001/, http://localhost:9002/");
        KieServerRouterEventListener client = new KieServerRouterEventListener();
        List routerUrls = client.routers();
        Assert.assertNotNull((Object)routerUrls);
        Assert.assertEquals((long)3L, (long)routerUrls.size());
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9000"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9001"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9002"));
    }
}

