/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.client;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.router.client.KieServerRouterEventListener;

public class KieServerRouterEventListenerTest {
    @After
    public void cleanup() {
        System.clearProperty("org.kie.server.router");
        System.clearProperty("org.kie.server.id");
    }

    @Before
    public void setup() {
        System.setProperty("org.kie.server.id", "sample-id");
    }

    @Test
    public void testRouterUrlsWithSlashAtTheEnd() {
        System.setProperty("org.kie.server.router", "http://localhost:9000/,http://localhost:9001/, http://localhost:9002/");
        KieServerRouterEventListener client = new KieServerRouterEventListener();
        List routerUrls = client.routers();
        Assert.assertNotNull((Object)routerUrls);
        Assert.assertEquals((long)3L, (long)routerUrls.size());
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9000"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9001"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9002"));
    }

    @Test
    public void testRouterUrlsWithoutSlashAtTheEnd() {
        System.setProperty("org.kie.server.router", "http://localhost:9000,http://localhost:9001, http://localhost:9002");
        KieServerRouterEventListener client = new KieServerRouterEventListener();
        List routerUrls = client.routers();
        Assert.assertNotNull((Object)routerUrls);
        Assert.assertEquals((long)3L, (long)routerUrls.size());
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9000"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9001"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9002"));
    }

    @Test
    public void testRouterUrlsWithAndWithoutSlashAtTheEnd() {
        System.setProperty("org.kie.server.router", "http://localhost:9000,http://localhost:9001/, http://localhost:9002/");
        KieServerRouterEventListener client = new KieServerRouterEventListener();
        List routerUrls = client.routers();
        Assert.assertNotNull((Object)routerUrls);
        Assert.assertEquals((long)3L, (long)routerUrls.size());
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9000"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9001"));
        Assert.assertTrue((boolean)routerUrls.contains("http://localhost:9002"));
    }

    @Test
    public void testListenerUsername() {
        KieServerRouterEventListener client = new KieServerRouterEventListener();
        Assert.assertEquals((Object)"sample-id", (Object)client.getUsername());
    }

    @Test
    public void testListenerOverwriteUsername() {
        System.setProperty("org.kie.server.router.management.username", "sample-id-overwrite");
        KieServerRouterEventListener client = new KieServerRouterEventListener();
        Assert.assertEquals((Object)"sample-id-overwrite", (Object)client.getUsername());
        System.clearProperty("org.kie.server.router.management.username");
    }
}

