/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.casemgmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.kie.api.task.model.Status;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.cases.CaseAdHocFragment;
import org.kie.server.api.model.cases.CaseAdHocFragmentList;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseDefinitionList;
import org.kie.server.api.model.cases.CaseFileDataItemList;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseMilestone;
import org.kie.server.api.model.cases.CaseMilestoneList;
import org.kie.server.api.model.cases.CaseStage;
import org.kie.server.api.model.cases.CaseStageList;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.ConvertUtils;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;

public class CaseManagementRuntimeDataServiceBase {
    private CaseRuntimeDataService caseRuntimeDataService;
    private KieServerRegistry context;
    private IdentityProvider identityProvider;
    private boolean bypassAuthUser = false;

    public CaseManagementRuntimeDataServiceBase(CaseRuntimeDataService caseRuntimeDataService, KieServerRegistry context) {
        this.caseRuntimeDataService = caseRuntimeDataService;
        this.identityProvider = context.getIdentityProvider();
        this.context = context;
        this.bypassAuthUser = Boolean.parseBoolean(context.getConfig().getConfigItemValue("org.kie.server.bypass.auth.user", "false"));
    }

    protected String getUser(String queryParamUser) {
        if (this.bypassAuthUser) {
            return queryParamUser;
        }
        return this.identityProvider.getName();
    }

    public CaseMilestoneList getMilestones(String containerId, String caseId, boolean achievedOnly, Integer page, Integer pageSize) {
        Collection caseMilestones = this.caseRuntimeDataService.getCaseInstanceMilestones(caseId, achievedOnly, ConvertUtils.buildQueryContext(page, pageSize));
        List<CaseMilestone> milestones = ConvertUtils.transformMilestones(caseMilestones);
        CaseMilestoneList milestoneList = new CaseMilestoneList(milestones);
        return milestoneList;
    }

    public CaseStageList getStages(String containerId, String caseId, boolean activeOnly, Integer page, Integer pageSize) {
        Collection caseStageInstances = this.caseRuntimeDataService.getCaseInstanceStages(caseId, activeOnly, ConvertUtils.buildQueryContext(page, pageSize));
        List<CaseStage> caseStages = ConvertUtils.transformStages(caseStageInstances);
        CaseStageList stageList = new CaseStageList(caseStages);
        return stageList;
    }

    public CaseAdHocFragmentList getAdHocFragments(String containerId, String caseId) {
        Collection caseAdHocFragments = this.caseRuntimeDataService.getAdHocFragmentsForCase(caseId);
        List caseAdHoc = caseAdHocFragments.stream().map(adf -> CaseAdHocFragment.builder().name(adf.getName()).type(adf.getType()).build()).collect(Collectors.toList());
        CaseAdHocFragmentList adHocFragmentList = new CaseAdHocFragmentList(caseAdHoc);
        return adHocFragmentList;
    }

    public NodeInstanceList getActiveNodes(String containerId, String caseId, Integer page, Integer pageSize) {
        Collection activeNodeInstances = this.caseRuntimeDataService.getActiveNodesForCase(caseId, ConvertUtils.buildQueryContext(page, pageSize));
        List<NodeInstance> activeNodes = ConvertUtils.transformNodeInstance(activeNodeInstances);
        NodeInstanceList activeNodesList = new NodeInstanceList(activeNodes);
        return activeNodesList;
    }

    public NodeInstanceList getCompletedNodes(String containerId, String caseId, Integer page, Integer pageSize) {
        Collection completedNodeInstances = this.caseRuntimeDataService.getCompletedNodesForCase(caseId, ConvertUtils.buildQueryContext(page, pageSize));
        List<NodeInstance> completedNodes = ConvertUtils.transformNodeInstance(completedNodeInstances);
        NodeInstanceList completedNodesList = new NodeInstanceList(completedNodes);
        return completedNodesList;
    }

    public ProcessInstanceList getProcessInstancesForCase(String containerId, String caseId, List<Integer> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        status = this.safeProcessStatus(status);
        sort = this.safeProcessInstanceSort(sort);
        Collection processInstanceDescs = this.caseRuntimeDataService.getProcessInstancesForCase(caseId, status, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<ProcessInstance> processInstances = ConvertUtils.transformProcessInstance(processInstanceDescs);
        ProcessInstanceList processInstancesList = new ProcessInstanceList(processInstances);
        return processInstancesList;
    }

    public CaseInstanceList getCaseInstancesByContainer(String containerId, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<CaseStatus> caseStatus = this.safeCaseStatus(status);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstancesByDeployment(containerId, caseStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseInstanceList getCaseInstancesByDefinition(String containerId, String caseDefinitionId, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<CaseStatus> caseStatus = this.safeCaseStatus(status);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstancesByDefinition(caseDefinitionId, caseStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseInstanceList getCaseInstancesOwnedBy(String owner, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<CaseStatus> caseStatus = this.safeCaseStatus(status);
        owner = this.getUser(owner);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstancesOwnedBy(owner, caseStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseInstanceList getCaseInstances(List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<CaseStatus> caseStatus = this.safeCaseStatus(status);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstances(caseStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseInstanceList getCaseInstancesByRole(String roleName, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<CaseStatus> caseStatus = this.safeCaseStatus(status);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstancesByRole(roleName, caseStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseInstanceList getCaseInstancesAnyRole(List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<CaseStatus> caseStatus = this.safeCaseStatus(status);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = this.caseRuntimeDataService.getCaseInstancesAnyRole(caseStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseInstanceList getCaseInstancesByCaseFileData(String dataItemName, String dataItemValue, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<CaseStatus> caseStatus = this.safeCaseStatus(status);
        sort = this.safeCaseInstanceSort(sort);
        Collection caseInstanceDescs = null;
        caseInstanceDescs = dataItemValue != null && !dataItemValue.isEmpty() ? this.caseRuntimeDataService.getCaseInstancesByDataItemAndValue(dataItemName, dataItemValue, caseStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder)) : this.caseRuntimeDataService.getCaseInstancesByDataItem(dataItemName, caseStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseInstance> caseInstances = ConvertUtils.transformCaseInstances(caseInstanceDescs);
        CaseInstanceList caseInstancesList = new CaseInstanceList(caseInstances);
        return caseInstancesList;
    }

    public CaseDefinitionList getCaseDefinitionsByContainer(String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        sort = this.safeCaseDefinitionSort(sort);
        try {
            containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
            Collection caseDescs = this.caseRuntimeDataService.getCasesByDeployment(containerId, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
            List<CaseDefinition> cases = ConvertUtils.transformCases(caseDescs);
            CaseDefinitionList caseList = new CaseDefinitionList(cases);
            return caseList;
        }
        catch (IllegalArgumentException e) {
            return new CaseDefinitionList();
        }
    }

    public CaseDefinitionList getCaseDefinitions(String filter, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        Collection caseDescs = null;
        sort = this.safeCaseDefinitionSort(sort);
        caseDescs = filter != null && !filter.isEmpty() ? this.caseRuntimeDataService.getCases(filter, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder)) : this.caseRuntimeDataService.getCases(ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        List<CaseDefinition> cases = ConvertUtils.transformCases(caseDescs);
        CaseDefinitionList caseList = new CaseDefinitionList(cases);
        return caseList;
    }

    public ProcessDefinitionList getProcessDefinitions(String filter, String containerId, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        Collection processDescs = null;
        sort = this.safeCaseDefinitionSort(sort);
        if (containerId != null && !containerId.isEmpty()) {
            try {
                containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            processDescs = this.caseRuntimeDataService.getProcessDefinitionsByDeployment(containerId, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        } else {
            processDescs = filter != null && !filter.isEmpty() ? this.caseRuntimeDataService.getProcessDefinitions(filter, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder)) : this.caseRuntimeDataService.getProcessDefinitions(ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        }
        ProcessDefinitionList processDefinitions = ConvertUtils.transformProcesses(processDescs);
        return processDefinitions;
    }

    public CaseDefinition getCaseDefinition(String containerId, String caseDefinitionId) {
        try {
            containerId = this.context.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
            org.jbpm.casemgmt.api.model.CaseDefinition caseDef = this.caseRuntimeDataService.getCase(containerId, caseDefinitionId);
            if (caseDef == null) {
                throw new IllegalStateException("Case definition " + containerId + " : " + caseDefinitionId + " not found");
            }
            CaseDefinition caseDefinition = ConvertUtils.transformCase(caseDef);
            return caseDefinition;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Case definition " + containerId + " : " + caseDefinitionId + " not found");
        }
    }

    public TaskSummaryList getCaseTasks(String caseId, String user, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<Status> actualStatus = this.safeTaskStatus(status);
        user = this.getUser(user);
        sort = this.safeTaskSummarySort(sort);
        List taskSummaries = this.caseRuntimeDataService.getCaseTasksAssignedAsPotentialOwner(caseId, user, actualStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        TaskSummaryList tasks = ConvertUtils.convertToTaskSummaryList(taskSummaries);
        return tasks;
    }

    public TaskSummaryList getCaseTasksAsBusinessAdmin(String caseId, String user, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<Status> actualStatus = this.safeTaskStatus(status);
        user = this.getUser(user);
        sort = this.safeTaskSummarySort(sort);
        List taskSummaries = this.caseRuntimeDataService.getCaseTasksAssignedAsBusinessAdmin(caseId, user, actualStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        TaskSummaryList tasks = ConvertUtils.convertToTaskSummaryList(taskSummaries);
        return tasks;
    }

    public TaskSummaryList getCaseTasksAsStakeholder(String caseId, String user, List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        List<Status> actualStatus = this.safeTaskStatus(status);
        user = this.getUser(user);
        sort = this.safeTaskSummarySort(sort);
        List taskSummaries = this.caseRuntimeDataService.getCaseTasksAssignedAsStakeholder(caseId, user, actualStatus, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        TaskSummaryList tasks = ConvertUtils.convertToTaskSummaryList(taskSummaries);
        return tasks;
    }

    public CaseFileDataItemList getCaseInstanceDataItems(String caseId, List<String> names, List<String> types, Integer page, Integer pageSize) {
        Collection caseFileItems = null;
        caseFileItems = !names.isEmpty() ? this.caseRuntimeDataService.getCaseInstanceDataItemsByName(caseId, names, ConvertUtils.buildQueryContext(page, pageSize)) : (!types.isEmpty() ? this.caseRuntimeDataService.getCaseInstanceDataItemsByType(caseId, types, ConvertUtils.buildQueryContext(page, pageSize)) : this.caseRuntimeDataService.getCaseInstanceDataItems(caseId, ConvertUtils.buildQueryContext(page, pageSize)));
        CaseFileDataItemList caseFileDataItemList = ConvertUtils.transformCaseFileDataItems(caseFileItems);
        return caseFileDataItemList;
    }

    protected List<CaseStatus> safeCaseStatus(List<String> status) {
        ArrayList<CaseStatus> actualStatus = CaseStatus.fromNameList(status);
        if (actualStatus == null || actualStatus.isEmpty()) {
            actualStatus = new ArrayList<CaseStatus>();
            actualStatus.add(CaseStatus.OPEN);
        }
        return actualStatus;
    }

    protected List<Integer> safeProcessStatus(List<Integer> status) {
        List<Integer> actualStatus = status;
        if (status == null || status.isEmpty()) {
            actualStatus = new ArrayList<Integer>();
            actualStatus.add(1);
        }
        return actualStatus;
    }

    protected List<Status> safeTaskStatus(List<String> status) {
        ArrayList<Status> actualStatus;
        if (status == null || status.isEmpty()) {
            actualStatus = new ArrayList<Status>();
            actualStatus.add(Status.Ready);
            actualStatus.add(Status.Reserved);
            actualStatus.add(Status.InProgress);
        } else {
            actualStatus = status.stream().map(s -> Status.valueOf((String)s)).collect(Collectors.toList());
        }
        return actualStatus;
    }

    protected String safeCaseInstanceSort(String sort) {
        String actualSort = sort;
        if (sort == null || sort.isEmpty()) {
            actualSort = "CorrelationKey";
        }
        return actualSort;
    }

    protected String safeTaskSummarySort(String sort) {
        String actualSort = sort;
        if (sort == null || sort.isEmpty()) {
            actualSort = "t.id";
        }
        return actualSort;
    }

    protected String safeCaseDefinitionSort(String sort) {
        String actualSort = sort;
        if (sort == null || sort.isEmpty()) {
            actualSort = "CaseId";
        }
        return actualSort;
    }

    protected String safeProcessInstanceSort(String sort) {
        String actualSort = sort;
        if (sort == null || sort.isEmpty()) {
            actualSort = "ProcessInstanceId";
        }
        return actualSort;
    }
}

