/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;

public class KieServerStateTest {
    @BeforeClass
    public static void setupOnce() {
        System.setProperty("org.kie.server.repo", "./target");
    }

    @AfterClass
    public static void cleanupOnce() {
        System.clearProperty("org.kie.server.repo");
    }

    @After
    public void cleanup() {
        System.clearProperty("org.kie.server.persistence.dialect");
        System.clearProperty("org.kie.server.persistence.ds");
        System.clearProperty("org.kie.server.persistence.tm");
    }

    @Test
    public void testLoadKieServerState() {
        KieServerStateFileRepository repository = new KieServerStateFileRepository();
        String serverId = UUID.randomUUID().toString();
        KieServerState state = repository.load(serverId);
        Assert.assertNotNull((Object)state);
        KieServerConfig config = state.getConfiguration();
        Assert.assertNotNull((Object)config);
        Assert.assertNull((Object)config.getConfigItemValue("org.kie.server.persistence.dialect"));
        Assert.assertNull((Object)config.getConfigItemValue("org.kie.server.persistence.ds"));
        Assert.assertNull((Object)config.getConfigItemValue("org.kie.server.persistence.tm"));
        System.setProperty("org.kie.server.persistence.dialect", "org.hibernate.dialect.PostgreSQLDialect");
        System.setProperty("org.kie.server.persistence.ds", "jdbc/jbpm");
        System.setProperty("org.kie.server.persistence.tm", "org.hibernate.service.jta.platform.internal.BitronixJtaPlatform");
        repository.store(serverId, state);
        repository = new KieServerStateFileRepository();
        state = repository.load(serverId);
        Assert.assertNotNull((Object)state);
        config = state.getConfiguration();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"org.hibernate.dialect.PostgreSQLDialect", (Object)config.getConfigItemValue("org.kie.server.persistence.dialect"));
        Assert.assertEquals((Object)"jdbc/jbpm", (Object)config.getConfigItemValue("org.kie.server.persistence.ds"));
        Assert.assertEquals((Object)"org.hibernate.service.jta.platform.internal.BitronixJtaPlatform", (Object)config.getConfigItemValue("org.kie.server.persistence.tm"));
    }

    @Test
    public void testLoadKieServerStateWithProperties() {
        KieServerStateFileRepository repository = new KieServerStateFileRepository();
        System.setProperty("org.kie.server.persistence.dialect", "org.hibernate.dialect.PostgreSQLDialect");
        System.setProperty("org.kie.server.persistence.ds", "jdbc/jbpm");
        System.setProperty("org.kie.server.persistence.tm", "org.hibernate.service.jta.platform.internal.BitronixJtaPlatform");
        String serverId = UUID.randomUUID().toString();
        KieServerState state = repository.load(serverId);
        Assert.assertNotNull((Object)state);
        KieServerConfig config = state.getConfiguration();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"org.hibernate.dialect.PostgreSQLDialect", (Object)config.getConfigItemValue("org.kie.server.persistence.dialect"));
        Assert.assertEquals((Object)"jdbc/jbpm", (Object)config.getConfigItemValue("org.kie.server.persistence.ds"));
        Assert.assertEquals((Object)"org.hibernate.service.jta.platform.internal.BitronixJtaPlatform", (Object)config.getConfigItemValue("org.kie.server.persistence.tm"));
    }
}

