/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Set;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManager {
    private static final Logger logger = LoggerFactory.getLogger(ContainerManager.class);

    public void installContainers(KieServerImpl kieServer, Set<KieContainerResource> containers, KieServerState currentState, KieServerSetup kieServerSetup) {
        this.installContainersSync(kieServer, containers, currentState, kieServerSetup);
    }

    public void installContainersSync(KieServerImpl kieServer, Set<KieContainerResource> containers, KieServerState currentState, KieServerSetup kieServerSetup) {
        logger.info("About to install containers '{}' on kie server '{}'", containers, (Object)kieServer);
        if (containers == null) {
            kieServer.markAsReady();
            return;
        }
        for (KieContainerResource containerResource : containers) {
            if (!KieContainerStatus.STARTED.equals((Object)containerResource.getStatus())) continue;
            kieServer.createContainer(containerResource.getContainerId(), containerResource);
        }
        currentState.setContainers(containers);
        if (kieServerSetup.getServerConfig() != null) {
            currentState.setConfiguration(kieServerSetup.getServerConfig());
        }
        kieServer.getServerRegistry().getStateRepository().store(KieServerEnvironment.getServerId(), currentState);
        kieServer.markAsReady();
    }
}

