/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.storage.file;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.impl.KieServerContainerDeployment;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerStateFileInit {
    private static final Logger logger = LoggerFactory.getLogger(KieServerStateFileInit.class);

    private KieServerStateFileInit() {
    }

    public static void main(String ... args) {
        File serverStateFile = KieServerStateFileInit.init();
        logger.info("Initialized kie server state file: {}", (Object)serverStateFile);
    }

    public static File init() {
        String serverRepo = KieServerStateFileInit.getValue("org.kie.server.repo", "KIE_SERVER_REPO", ".");
        String serverId = KieServerStateFileInit.getValue("org.kie.server.id", "KIE_SERVER_ID", "kieserver");
        KieServerEnvironment.setServerId((String)serverId);
        KieServerEnvironment.setServerName((String)serverId);
        File serverRepoDir = new File(serverRepo);
        File serverStateFile = new File(serverRepoDir, serverId + ".xml");
        if (serverStateFile.exists()) {
            throw new IllegalStateException(String.format("%s already exists. %s should only be used for pre-bootstrapping creation of server state file.", serverStateFile, KieServerStateFileInit.class.getSimpleName()));
        }
        KieServerStateFileRepository repository = new KieServerStateFileRepository(serverRepoDir);
        KieServerState serverState = new KieServerState();
        KieServerConfig config = new KieServerConfig();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.put("org.kie.server.repo", serverRepo);
        properties.put("org.kie.server.id", serverId);
        repository.populateWithProperties(config, properties);
        serverState.setConfiguration(config);
        LinkedHashSet<KieContainerResource> containers = new LinkedHashSet<KieContainerResource>();
        String serverContainerDeployment = KieServerStateFileInit.getValue("org.kie.server.container.deployment", "KIE_SERVER_CONTAINER_DEPLOYMENT", null);
        Set<KieServerContainerDeployment> deployments = KieServerContainerDeployment.fromString(serverContainerDeployment);
        for (KieServerContainerDeployment deployment : deployments) {
            KieContainerResource container = new KieContainerResource(deployment.getContainerId(), new ReleaseId(deployment.getReleaseId()), KieContainerStatus.STARTED);
            containers.add(container);
        }
        serverState.setContainers(containers);
        repository.store(serverId, serverState);
        return serverStateFile;
    }

    private static String getValue(String propName, String envName, String defaultValue) {
        String value = null;
        if (propName != null) {
            value = KieServerStateFileInit.trimToNull(System.getProperty(propName));
        }
        if (value == null && envName != null) {
            value = KieServerStateFileInit.trimToNull(System.getenv(envName));
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String trimToNull(String s) {
        if (s != null && (s = s.trim()).isEmpty()) {
            s = null;
        }
        return s;
    }
}

