/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.AbstractKieServerImplTest;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerImplDevelopmentModeTest
extends AbstractKieServerImplTest {
    @Override
    KieServerMode getTestMode() {
        return KieServerMode.DEVELOPMENT;
    }

    @Test
    public void testCreateContainerValidationSNAPSHOT() {
        this.testCreateContainer(this.getVersion(KieServerMode.DEVELOPMENT));
    }

    @Test
    public void testCreateContainerValidationNonSNAPSHOT() {
        this.testCreateContainer(this.getVersion(KieServerMode.PRODUCTION));
    }

    @Test
    public void testUpdateContainerNonSnapshot() {
        this.testUpdateContainer(this.getVersion(KieServerMode.PRODUCTION));
    }

    @Test
    public void testUpdateContainerSNAPSHOT() {
        this.testUpdateContainer(this.getVersion(KieServerMode.DEVELOPMENT));
    }

    private void testCreateContainer(String version) {
        String containerId = "container-to-create";
        this.createEmptyKjar(containerId, version);
        ReleaseId testReleaseId = new ReleaseId("org.kie.server.test", containerId, version);
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, testReleaseId);
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        kieContainerResource.setScanner(kieScannerResource);
        ServiceResponse createResponse = this.kieServer.createContainer(containerId, kieContainerResource);
        Assertions.assertThat((Comparable)createResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        this.kieServer.disposeContainer(containerId);
    }

    private void testUpdateContainer(String version) {
        KieServerExtension extension = (KieServerExtension)Mockito.mock(KieServerExtension.class);
        Mockito.when((Object)extension.isUpdateContainerAllowed((String)Matchers.any(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)true);
        this.extensions.add(extension);
        String containerId = "container-to-update";
        this.startContainerToUpdate(containerId, version);
        ReleaseId updateReleaseId = new ReleaseId("org.kie.server.test", containerId, version);
        ServiceResponse updateResponse = this.kieServer.updateContainerReleaseId(containerId, updateReleaseId, true);
        Assertions.assertThat((Comparable)updateResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        ((KieServerExtension)Mockito.verify((Object)extension)).isUpdateContainerAllowed(Matchers.anyString(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
        ((KieServerExtension)Mockito.verify((Object)extension)).updateContainer((String)Matchers.any(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
        this.kieServer.disposeContainer(containerId);
    }
}

