/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.core.impl.InternalKieContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.builder.KieScanner;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KieServerImplOperationTest {
    private static final File REPOSITORY_DIR = new File("target/repository-dir");
    private static final String KIE_SERVER_ID = "kie-server-impl-test";
    private KieServerImpl kieServer;
    private String origServerId = null;
    private KieServerStateRepository repository;

    @Before
    public void setupKieServerImpl() throws Exception {
        this.origServerId = KieServerEnvironment.getServerId();
        System.setProperty("org.kie.server.id", KIE_SERVER_ID);
        KieServerEnvironment.setServerId((String)KIE_SERVER_ID);
        FileUtils.deleteDirectory((File)REPOSITORY_DIR);
        FileUtils.forceMkdir((File)REPOSITORY_DIR);
        this.repository = new KieServerStateFileRepository(REPOSITORY_DIR);
        this.kieServer = new KieServerImpl(this.repository){

            protected Map<String, Object> getContainerParameters(org.kie.api.builder.ReleaseId releaseId, List<Message> messages) {
                return Collections.emptyMap();
            }
        };
        this.kieServer.init();
    }

    @After
    public void cleanUp() {
        if (this.kieServer != null) {
            this.kieServer.destroy();
        }
        KieServerEnvironment.setServerId((String)this.origServerId);
    }

    @Test
    public void testDisposeContainerWithScanner() {
        InternalKieScanner mockedScanner = (InternalKieScanner)Mockito.mock(InternalKieScanner.class);
        Mockito.when((Object)mockedScanner.getStatus()).thenReturn((Object)KieScanner.Status.RUNNING);
        InternalKieContainer mockedKieContainer = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)mockedKieContainer.getReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        KieContainerInstanceImpl kieContainerInstance = (KieContainerInstanceImpl)Mockito.mock(KieContainerInstanceImpl.class);
        Mockito.when((Object)kieContainerInstance.getContainerId()).thenReturn((Object)"id");
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        Mockito.when((Object)kieContainerInstance.getKieContainer()).thenReturn((Object)mockedKieContainer);
        Mockito.when((Object)kieContainerInstance.getResource()).thenReturn((Object)new KieContainerResource("id", new ReleaseId("g", "a", "v")));
        Mockito.when((Object)kieContainerInstance.getScanner()).thenReturn((Object)mockedScanner);
        this.kieServer.getServerRegistry().registerContainer("id", kieContainerInstance);
        this.kieServer.disposeContainer("id");
        ((KieContainerInstanceImpl)Mockito.verify((Object)kieContainerInstance, (VerificationMode)Mockito.times((int)1))).stopScanner();
    }

    @Test
    public void testDisposeContainerWithNoScanner() {
        InternalKieContainer mockedKieContainer = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)mockedKieContainer.getReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        KieContainerInstanceImpl kieContainerInstance = (KieContainerInstanceImpl)Mockito.mock(KieContainerInstanceImpl.class);
        Mockito.when((Object)kieContainerInstance.getContainerId()).thenReturn((Object)"id");
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        Mockito.when((Object)kieContainerInstance.getKieContainer()).thenReturn((Object)mockedKieContainer);
        Mockito.when((Object)kieContainerInstance.getResource()).thenReturn((Object)new KieContainerResource("id", new ReleaseId("g", "a", "v")));
        this.kieServer.getServerRegistry().registerContainer("id", kieContainerInstance);
        this.kieServer.disposeContainer("id");
        ((KieContainerInstanceImpl)Mockito.verify((Object)kieContainerInstance, (VerificationMode)Mockito.times((int)0))).stopScanner();
    }

    @Test
    public void testActivateAndDeactivateContainer() {
        InternalKieContainer mockedKieContainer = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)mockedKieContainer.getReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        KieContainerResource container = new KieContainerResource("id", new ReleaseId("g", "a", "v"));
        KieContainerInstanceImpl kieContainerInstance = (KieContainerInstanceImpl)Mockito.mock(KieContainerInstanceImpl.class);
        Mockito.when((Object)kieContainerInstance.getContainerId()).thenReturn((Object)"id");
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        Mockito.when((Object)kieContainerInstance.getKieContainer()).thenReturn((Object)mockedKieContainer);
        Mockito.when((Object)kieContainerInstance.getResource()).thenReturn((Object)container);
        this.kieServer.getServerRegistry().registerContainer("id", kieContainerInstance);
        KieServerState currentState = this.repository.load(KIE_SERVER_ID);
        currentState.getContainers().add(container);
        this.repository.store(KIE_SERVER_ID, currentState);
        this.kieServer.deactivateContainer("id");
        currentState = this.repository.load(KIE_SERVER_ID);
        Assert.assertNotNull((Object)currentState);
        Assert.assertNotNull((Object)currentState.getContainers());
        Assert.assertEquals((long)1L, (long)currentState.getContainers().size());
        container = (KieContainerResource)currentState.getContainers().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)KieContainerStatus.DEACTIVATED, (Object)container.getStatus());
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.DEACTIVATED);
        this.kieServer.activateContainer("id");
        currentState = this.repository.load(KIE_SERVER_ID);
        Assert.assertNotNull((Object)currentState);
        Assert.assertNotNull((Object)currentState.getContainers());
        Assert.assertEquals((long)1L, (long)currentState.getContainers().size());
        container = (KieContainerResource)currentState.getContainers().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)container.getStatus());
    }
}

