/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.server.services.impl.KieServerContainerDeployment;

public class KieServerContainerDeploymentTest {
    private static final String letters = "letters";
    private static final String test = "test";
    private static final String example = "example";
    private static final ReleaseId gav0 = KieServerContainerDeploymentTest.newReleaseId("abc.def:ghi:9.0.1.GA");
    private static final ReleaseId gav1 = KieServerContainerDeploymentTest.newReleaseId("com.test:foo:1.0.0-SNAPSHOT");
    private static final ReleaseId gav2 = KieServerContainerDeploymentTest.newReleaseId("com.test:foo:1.0.0.Final");
    private static final ReleaseId gav3 = KieServerContainerDeploymentTest.newReleaseId("com.test:foo:2.0.0-SNAPSHOT");
    private static final ReleaseId gav4 = KieServerContainerDeploymentTest.newReleaseId("com.test:foo:2.0.0.Alpha1");
    private static final ReleaseId gav5 = KieServerContainerDeploymentTest.newReleaseId("com.test:foo:2.0.0.Beta2");
    private static final ReleaseId gav6 = KieServerContainerDeploymentTest.newReleaseId("org.example:test:0.0.1-SNAPSHOT");
    private static final ReleaseId gav7 = KieServerContainerDeploymentTest.newReleaseId("org.example:test:1.0");
    private static final String canonicalRepresentation = "example=org.example:test:1.0|letters=abc.def:ghi:9.0.1.GA|test=com.test:foo:2.0.0.Beta2";
    private static final String serverContainerDeployment;

    private static final ReleaseId newReleaseId(String releaseId) {
        String[] gav = releaseId.split(":");
        return KieServices.Factory.get().newReleaseId(gav[0], gav[1], gav[2]);
    }

    @Test
    public void testDeploymentFiltering() throws Exception {
        Set deployments = KieServerContainerDeployment.fromString((String)serverContainerDeployment, (boolean)false);
        Assert.assertEquals((long)8L, (long)deployments.size());
        deployments = KieServerContainerDeployment.fromString((String)serverContainerDeployment, (boolean)true);
        Assert.assertEquals((long)3L, (long)deployments.size());
        deployments = KieServerContainerDeployment.fromString((String)serverContainerDeployment);
        Assert.assertEquals((long)3L, (long)deployments.size());
    }

    @Test
    public void testDeploymentRepresentation() throws Exception {
        Set deploymentsA = KieServerContainerDeployment.fromString((String)serverContainerDeployment);
        Assert.assertEquals((long)3L, (long)deploymentsA.size());
        String out = KieServerContainerDeployment.toString((Collection)deploymentsA);
        Assert.assertEquals((Object)canonicalRepresentation, (Object)out);
        Set deploymentsB = KieServerContainerDeployment.fromString((String)out);
        Assert.assertEquals((long)3L, (long)deploymentsB.size());
        Assert.assertEquals((Object)deploymentsA, (Object)deploymentsB);
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append(letters).append('=').append(gav0.toExternalForm()).append('|');
        for (ReleaseId gav : new ReleaseId[]{gav1, gav2, gav3, gav4, gav5}) {
            sb.append(test).append('=').append(gav.toExternalForm()).append('|');
        }
        sb.append(example).append('=').append(gav6.toExternalForm()).append('|');
        sb.append(example).append('=').append(gav7.toExternalForm());
        serverContainerDeployment = sb.toString();
    }
}

