/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.io.File;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;

public class KieServerStateTest {
    private static final File REPOSITORY_DIR = new File("target/repository-dir");

    @Before
    public void setup() throws Exception {
        FileUtils.deleteDirectory((File)REPOSITORY_DIR);
        FileUtils.forceMkdir((File)REPOSITORY_DIR);
    }

    @After
    public void cleanup() {
        System.clearProperty("org.kie.server.persistence.dialect");
        System.clearProperty("org.kie.server.persistence.ds");
        System.clearProperty("org.kie.server.persistence.tm");
    }

    @Test
    public void testLoadKieServerState() {
        KieServerStateFileRepository repository = new KieServerStateFileRepository(REPOSITORY_DIR);
        String serverId = UUID.randomUUID().toString();
        KieServerState state = repository.load(serverId);
        Assert.assertNotNull((Object)state);
        KieServerConfig config = state.getConfiguration();
        Assert.assertNotNull((Object)config);
        Assert.assertNull((Object)config.getConfigItemValue("org.kie.server.persistence.dialect"));
        Assert.assertNull((Object)config.getConfigItemValue("org.kie.server.persistence.ds"));
        Assert.assertNull((Object)config.getConfigItemValue("org.kie.server.persistence.tm"));
        System.setProperty("org.kie.server.persistence.dialect", "org.hibernate.dialect.PostgreSQLDialect");
        System.setProperty("org.kie.server.persistence.ds", "jdbc/jbpm");
        System.setProperty("org.kie.server.persistence.tm", "JBossTS");
        repository.store(serverId, state);
        repository = new KieServerStateFileRepository(REPOSITORY_DIR);
        state = repository.load(serverId);
        Assert.assertNotNull((Object)state);
        config = state.getConfiguration();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"org.hibernate.dialect.PostgreSQLDialect", (Object)config.getConfigItemValue("org.kie.server.persistence.dialect"));
        Assert.assertEquals((Object)"jdbc/jbpm", (Object)config.getConfigItemValue("org.kie.server.persistence.ds"));
        Assert.assertEquals((Object)"JBossTS", (Object)config.getConfigItemValue("org.kie.server.persistence.tm"));
    }

    @Test
    public void testLoadKieServerStateWithProperties() {
        KieServerStateFileRepository repository = new KieServerStateFileRepository(REPOSITORY_DIR);
        System.setProperty("org.kie.server.persistence.dialect", "org.hibernate.dialect.PostgreSQLDialect");
        System.setProperty("org.kie.server.persistence.ds", "jdbc/jbpm");
        System.setProperty("org.kie.server.persistence.tm", "JBossTS");
        String serverId = UUID.randomUUID().toString();
        KieServerState state = repository.load(serverId);
        Assert.assertNotNull((Object)state);
        KieServerConfig config = state.getConfiguration();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"org.hibernate.dialect.PostgreSQLDialect", (Object)config.getConfigItemValue("org.kie.server.persistence.dialect"));
        Assert.assertEquals((Object)"jdbc/jbpm", (Object)config.getConfigItemValue("org.kie.server.persistence.ds"));
        Assert.assertEquals((Object)"JBossTS", (Object)config.getConfigItemValue("org.kie.server.persistence.tm"));
    }
}

