/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.storage.file;

import java.io.File;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.file.KieServerStateFileInit;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;

public class KieServerStateFileInitTest {
    private static final String letters = "letters";
    private static final String test = "test";
    private static final String example = "example";
    private static final ReleaseId gav0 = KieServerStateFileInitTest.newReleaseId("abc.def:ghi:9.0.1.GA");
    private static final ReleaseId gav1 = KieServerStateFileInitTest.newReleaseId("com.test:foo:1.0.0-SNAPSHOT");
    private static final ReleaseId gav2 = KieServerStateFileInitTest.newReleaseId("com.test:foo:1.0.0.Final");
    private static final ReleaseId gav3 = KieServerStateFileInitTest.newReleaseId("com.test:foo:2.0.0-SNAPSHOT");
    private static final ReleaseId gav4 = KieServerStateFileInitTest.newReleaseId("com.test:foo:2.0.0.Alpha1");
    private static final ReleaseId gav5 = KieServerStateFileInitTest.newReleaseId("com.test:foo:2.0.0.Beta2");
    private static final ReleaseId gav6 = KieServerStateFileInitTest.newReleaseId("org.example:test:0.0.1-SNAPSHOT");
    private static final ReleaseId gav7 = KieServerStateFileInitTest.newReleaseId("org.example:test:1.0");
    private static final String serverContainerDeployment;
    private String origServerRepo = null;
    private String origServerId = null;
    private String origServerContainerDeployment = null;
    private File tempServerStateFile = null;

    private static final ReleaseId newReleaseId(String releaseId) {
        String[] gav = releaseId.split(":");
        return KieServices.Factory.get().newReleaseId(gav[0], gav[1], gav[2]);
    }

    @Before
    public void before() throws Exception {
        this.origServerRepo = System.getProperty("org.kie.server.repo");
        this.origServerId = System.getProperty("org.kie.server.id");
        this.origServerContainerDeployment = System.getProperty("org.kie.server.container.deployment");
        this.tempServerStateFile = File.createTempFile("kieserver-", ".xml");
        this.tempServerStateFile.delete();
        System.setProperty("org.kie.server.repo", this.getServerRepo(this.tempServerStateFile));
        System.setProperty("org.kie.server.id", this.getServerId(this.tempServerStateFile));
        System.setProperty("org.kie.server.container.deployment", serverContainerDeployment);
    }

    @Test
    public void testInit() throws Exception {
        File serverStateFile = KieServerStateFileInit.init();
        String serverRepo = this.getServerRepo(serverStateFile);
        String serverId = this.getServerId(serverStateFile);
        KieServerStateFileRepository repository = new KieServerStateFileRepository(new File(serverRepo));
        KieServerState serverState = repository.load(this.getServerId(serverStateFile));
        KieServerConfig config = serverState.getConfiguration();
        Assert.assertEquals((Object)serverRepo, (Object)config.getConfigItem("org.kie.server.repo").getValue());
        Assert.assertEquals((Object)serverId, (Object)config.getConfigItem("org.kie.server.id").getValue());
        Assert.assertEquals((Object)serverContainerDeployment, (Object)config.getConfigItem("org.kie.server.container.deployment").getValue());
        Iterator containers = serverState.getContainers().iterator();
        KieContainerResource exampleContainer = (KieContainerResource)containers.next();
        Assert.assertEquals((Object)example, (Object)exampleContainer.getContainerId());
        Assert.assertEquals((Object)gav7.toExternalForm(), (Object)exampleContainer.getReleaseId().toExternalForm());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)exampleContainer.getStatus());
        KieContainerResource lettersContainer = (KieContainerResource)containers.next();
        Assert.assertEquals((Object)letters, (Object)lettersContainer.getContainerId());
        Assert.assertEquals((Object)gav0.toExternalForm(), (Object)lettersContainer.getReleaseId().toExternalForm());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)lettersContainer.getStatus());
        KieContainerResource testContainer = (KieContainerResource)containers.next();
        Assert.assertEquals((Object)test, (Object)testContainer.getContainerId());
        Assert.assertEquals((Object)gav5.toExternalForm(), (Object)testContainer.getReleaseId().toExternalForm());
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)testContainer.getStatus());
    }

    private String getServerRepo(File serverStateFile) throws Exception {
        return serverStateFile.getParentFile().getCanonicalPath();
    }

    private String getServerId(File serverStateFile) {
        return serverStateFile.getName().substring(0, serverStateFile.getName().length() - 4);
    }

    @After
    public void after() throws Exception {
        if (this.origServerRepo != null) {
            System.setProperty("org.kie.server.repo", this.origServerRepo);
        } else {
            System.clearProperty("org.kie.server.repo");
        }
        if (this.origServerId != null) {
            System.setProperty("org.kie.server.id", this.origServerId);
        } else {
            System.clearProperty("org.kie.server.id");
        }
        if (this.origServerContainerDeployment != null) {
            System.setProperty("org.kie.server.container.deployment", this.origServerContainerDeployment);
        } else {
            System.clearProperty("org.kie.server.container.deployment");
        }
        this.tempServerStateFile.delete();
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append(letters).append('=').append(gav0.toExternalForm()).append('|');
        for (ReleaseId gav : new ReleaseId[]{gav1, gav2, gav3, gav4, gav5}) {
            sb.append(test).append('=').append(gav.toExternalForm()).append('|');
        }
        sb.append(example).append('=').append(gav6.toExternalForm()).append('|');
        sb.append(example).append('=').append(gav7.toExternalForm());
        serverContainerDeployment = sb.toString();
    }
}

