/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.ControllerBasedStartupStrategy;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.LocalContainersStartupStrategy;
import org.kie.server.services.impl.StartupStrategyProvider;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;

public class KieServerImplInitTest {
    private static final File REPOSITORY_DIR = new File("target/repository-dir");
    private static final String KIE_SERVER_ID = "kie-server-impl-test";
    private KieServerImpl kieServer;
    private String origServerId = null;

    @Before
    public void setupKieServerImpl() throws Exception {
        this.origServerId = KieServerEnvironment.getServerId();
        System.setProperty("org.kie.server.id", KIE_SERVER_ID);
        KieServerEnvironment.setServerId((String)KIE_SERVER_ID);
        FileUtils.deleteDirectory((File)REPOSITORY_DIR);
        FileUtils.forceMkdir((File)REPOSITORY_DIR);
    }

    @After
    public void cleanUp() {
        if (this.kieServer != null) {
            this.kieServer.destroy();
        }
        KieServerEnvironment.setServerId((String)this.origServerId);
        System.clearProperty("org.kie.server.startup.strategy");
        StartupStrategyProvider.clear();
    }

    @Test
    public void testStartupStrategyProviderDefault() {
        StartupStrategy strategy = StartupStrategyProvider.get().getStrategy();
        Assert.assertTrue((boolean)(strategy instanceof ControllerBasedStartupStrategy));
    }

    @Test
    public void testStartupStrategyProviderLocalContainers() {
        System.setProperty("org.kie.server.startup.strategy", LocalContainersStartupStrategy.class.getSimpleName());
        StartupStrategyProvider.clear();
        StartupStrategy strategy = StartupStrategyProvider.get().getStrategy();
        Assert.assertTrue((boolean)(strategy instanceof LocalContainersStartupStrategy));
    }

    @Test(timeout=10000L)
    public void testDefaultStartupStrategy() throws Exception {
        final TestContainerManager testContainerManager = new TestContainerManager();
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR)){

            protected ContainerManager getContainerManager() {
                return testContainerManager;
            }
        };
        this.kieServer.init();
        Assert.assertTrue((boolean)testContainerManager.isInstalled());
        Assert.assertEquals((long)0L, (long)testContainerManager.getInstalledContainers().size());
    }

    @Test(timeout=10000L)
    public void testDefaultStartupStrategyFromController() throws Exception {
        final TestContainerManager testContainerManager = new TestContainerManager();
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR)){

            protected ContainerManager getContainerManager() {
                return testContainerManager;
            }

            public KieServerController getController() {
                return new KieServerController(){

                    public void disconnect(KieServerInfo serverInfo) {
                    }

                    public KieServerSetup connect(KieServerInfo serverInfo) {
                        KieServerSetup serverSetup = new KieServerSetup();
                        KieContainerResource container = new KieContainerResource("test", new ReleaseId("", "", ""), KieContainerStatus.STARTED);
                        HashSet<KieContainerResource> containers = new HashSet<KieContainerResource>();
                        containers.add(container);
                        serverSetup.setContainers(containers);
                        return serverSetup;
                    }
                };
            }
        };
        this.kieServer.init();
        Assert.assertTrue((boolean)testContainerManager.isInstalled());
        Assert.assertEquals((long)1L, (long)testContainerManager.getInstalledContainers().size());
    }

    @Test(timeout=10000L)
    public void testLOcalContainersStartupStrategyFromController() throws Exception {
        System.setProperty("org.kie.server.startup.strategy", LocalContainersStartupStrategy.class.getSimpleName());
        StartupStrategyProvider.clear();
        final TestContainerManager testContainerManager = new TestContainerManager();
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR)){

            protected ContainerManager getContainerManager() {
                return testContainerManager;
            }

            public KieServerController getController() {
                return new KieServerController(){

                    public void disconnect(KieServerInfo serverInfo) {
                    }

                    public KieServerSetup connect(KieServerInfo serverInfo) {
                        KieServerSetup serverSetup = new KieServerSetup();
                        KieContainerResource container = new KieContainerResource("test", new ReleaseId("", "", ""), KieContainerStatus.STARTED);
                        HashSet<KieContainerResource> containers = new HashSet<KieContainerResource>();
                        containers.add(container);
                        serverSetup.setContainers(containers);
                        return serverSetup;
                    }
                };
            }
        };
        this.kieServer.init();
        Assert.assertTrue((boolean)testContainerManager.isInstalled());
        Assert.assertEquals((long)0L, (long)testContainerManager.getInstalledContainers().size());
    }

    private class TestContainerManager
    extends ContainerManager {
        private boolean installed = false;
        private Set<KieContainerResource> installedContainers;

        private TestContainerManager() {
        }

        public void installContainers(KieServerImpl kieServer, Set<KieContainerResource> containers, KieServerState currentState, KieServerSetup kieServerSetup) {
            this.installed = true;
            this.installedContainers = containers;
        }

        public void installContainersSync(KieServerImpl kieServer, Set<KieContainerResource> containers, KieServerState currentState, KieServerSetup kieServerSetup) {
            this.installed = true;
            this.installedContainers = containers;
        }

        public boolean isInstalled() {
            return this.installed;
        }

        public Set<KieContainerResource> getInstalledContainers() {
            return this.installedContainers;
        }
    }
}

