/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.AbstractKieServerImplTest;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerImplProductionModeTest
extends AbstractKieServerImplTest {
    @Override
    KieServerMode getTestMode() {
        return KieServerMode.PRODUCTION;
    }

    @Test
    public void testCreateContainerValidationGAVConflict() {
        String containerId = "container-to-create";
        ReleaseId testReleaseId = new ReleaseId("org.kie.server.test", containerId, this.getVersion(KieServerMode.DEVELOPMENT));
        this.createEmptyKjar(containerId, testReleaseId.getVersion());
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, testReleaseId);
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        kieContainerResource.setScanner(kieScannerResource);
        ServiceResponse createResponse = this.kieServer.createContainer(containerId, kieContainerResource);
        Assertions.assertThat((Comparable)createResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.FAILURE);
    }

    @Test
    public void testUpdateContainerWithGAVConflict() {
        KieServerExtension extension = (KieServerExtension)Mockito.mock(KieServerExtension.class);
        this.extensions.add(extension);
        String containerId = "container-to-update";
        ReleaseId updateReleaseId = new ReleaseId("org.kie.server.test", containerId, this.getVersion(KieServerMode.DEVELOPMENT));
        ServiceResponse updateResponse = this.kieServer.updateContainerReleaseId(containerId, updateReleaseId, true);
        Assertions.assertThat((Comparable)updateResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.FAILURE);
        ((KieServerExtension)Mockito.verify((Object)extension, (VerificationMode)Mockito.never())).isUpdateContainerAllowed(Matchers.anyString(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
        ((KieServerExtension)Mockito.verify((Object)extension, (VerificationMode)Mockito.never())).updateContainer((String)Matchers.any(), (KieContainerInstance)Matchers.any(), (Map)Matchers.any());
    }
}

