/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.search;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jbpm.services.api.query.QueryService;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.jbpm.search.JbpmSearchKieServerExtension;
import org.mockito.Mockito;

public class JbpmSearchKieServerExtensionTest {
    @Test
    public void testGetAppComponents() throws Exception {
        JbpmSearchKieServerExtension kieServerExtension = new JbpmSearchKieServerExtension();
        Field contextField = kieServerExtension.getClass().getDeclaredField("context");
        Field queryServiceField = kieServerExtension.getClass().getDeclaredField("queryService");
        contextField.setAccessible(true);
        queryServiceField.setAccessible(true);
        contextField.set(kieServerExtension, Mockito.mock(KieServerRegistry.class));
        queryServiceField.set(kieServerExtension, Mockito.mock(QueryService.class));
        List appComponents = kieServerExtension.getAppComponents(SupportedTransports.REST);
        Assert.assertEquals((long)3L, (long)appComponents.size());
    }

    public static class TestApplicationComponentsService
    implements KieServerApplicationComponentsService {
        public Collection<Object> getAppComponents(String extension, SupportedTransports type, Object ... services) {
            Assert.assertEquals((long)2L, (long)services.length);
            ArrayList<Object> appComponents = new ArrayList<Object>();
            appComponents.add("Test-Component");
            appComponents.add("Another-test-component");
            appComponents.add("Third-test-component");
            return appComponents;
        }
    }
}

