/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jbpm.process.svg.SVGImageProcessor;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.server.services.jbpm.ui.img.ImageReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(ImageServiceBase.class);
    private RuntimeDataService dataService;
    private Map<String, ImageReference> imageReferenceMap;

    public ImageServiceBase(RuntimeDataService dataService, Map<String, ImageReference> imageReferenceMap) {
        this.dataService = dataService;
        this.imageReferenceMap = imageReferenceMap;
    }

    private byte[] getProcessImageAsBytes(String containerId, String processId) {
        ProcessDefinition procDef = this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId);
        if (procDef == null) {
            throw new IllegalArgumentException("No process found for " + processId + " within container " + containerId);
        }
        byte[] imageSVG = this.imageReferenceMap.get(containerId).getImageContent(processId);
        if (imageSVG == null) {
            logger.warn("Could not find SVG image file for process '" + processId + "' within container " + containerId);
            return null;
        }
        return imageSVG;
    }

    public String getProcessImage(String containerId, String processId) {
        String imageSVGString = null;
        byte[] imageSVG = this.getProcessImageAsBytes(containerId, processId);
        if (imageSVG != null) {
            try {
                imageSVGString = new String(imageSVG, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.debug("UnsupportedEncodingException while building process image due to {}", (Object)e.getMessage());
            }
        }
        return imageSVGString;
    }

    public String getActiveProcessImage(String containerId, long procInstId) {
        ProcessInstanceDesc instance = this.dataService.getProcessInstanceById(procInstId);
        if (instance == null) {
            throw new ProcessInstanceNotFoundException("No instance found for process instance id " + procInstId);
        }
        String imageSVGString = null;
        byte[] imageSVG = this.getProcessImageAsBytes(containerId, instance.getProcessId());
        if (imageSVG != null) {
            Collection logs = this.dataService.getProcessInstanceFullHistory(procInstId, null);
            ArrayList<String> active = new ArrayList<String>(2);
            ArrayList<String> completed = new ArrayList<String>(logs.size() / 2);
            for (NodeInstanceDesc nodeLog : logs) {
                String nodeId = nodeLog.getNodeId();
                if (0 == ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)nodeLog).getType()) {
                    active.add(nodeId);
                    continue;
                }
                completed.add(nodeId);
            }
            ByteArrayInputStream svgStream = new ByteArrayInputStream(imageSVG);
            imageSVGString = SVGImageProcessor.transform((InputStream)svgStream, completed, active);
            return imageSVGString;
        }
        throw new IllegalArgumentException("No process found for " + instance.getProcessId() + " within container " + containerId);
    }
}

