/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.Task;
import org.kie.server.services.jbpm.ui.api.UIFormProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormServiceBase {
    public static final Logger logger = LoggerFactory.getLogger(FormServiceBase.class);
    private static final ServiceLoader<UIFormProvider> formProviders = ServiceLoader.load(UIFormProvider.class);
    private DefinitionService definitionService;
    private RuntimeDataService dataService;
    private UserTaskService userTaskService;
    private Set<UIFormProvider> providers = new LinkedHashSet<UIFormProvider>();

    public FormServiceBase(DefinitionService definitionService, RuntimeDataService dataService, UserTaskService userTaskService, FormManagerService formManagerService) {
        this.definitionService = definitionService;
        this.dataService = dataService;
        this.userTaskService = userTaskService;
        this.providers.addAll(this.collectFormProviders(formManagerService));
    }

    public String getFormDisplayProcess(String containerId, String processId, String lang) {
        ProcessDefinition processDesc = this.definitionService.getProcessDefinition(containerId, processId);
        if (processDesc == null) {
            throw new IllegalStateException("Process definition " + containerId + " : " + processId + " not found");
        }
        HashMap processData = this.definitionService.getProcessVariables(containerId, processId);
        if (processData == null) {
            processData = new HashMap();
        }
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("process", processDesc);
        renderContext.put("outputs", processData);
        renderContext.put("lang", lang);
        for (UIFormProvider provider : this.providers) {
            String template = provider.render(processDesc.getName(), processDesc, renderContext);
            if (StringUtils.isEmpty((CharSequence)template)) continue;
            return template;
        }
        logger.warn("Unable to find form to render for process '{}'", (Object)processDesc.getName());
        throw new IllegalStateException("No form for process with id " + processDesc.getName() + " found");
    }

    public String getFormDisplayTask(long taskId, String lang) {
        Task task = this.userTaskService.getTask(Long.valueOf(taskId));
        if (task == null) {
            throw new IllegalStateException("No task with id " + taskId + " found");
        }
        String name = task.getName();
        ProcessDefinition processDesc = this.dataService.getProcessesByDeploymentIdProcessId(task.getTaskData().getDeploymentId(), task.getTaskData().getProcessId());
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        Map input = this.userTaskService.getTaskInputContentByTaskId(Long.valueOf(taskId));
        renderContext.put("inputs", input);
        for (Map.Entry inputVar : input.entrySet()) {
            renderContext.put((String)inputVar.getKey(), inputVar.getValue());
        }
        renderContext.put("lang", lang);
        for (UIFormProvider provider : this.providers) {
            String template = provider.render(name, task, processDesc, renderContext);
            if (StringUtils.isEmpty((CharSequence)template)) continue;
            return template;
        }
        logger.warn("Unable to find form to render for task '{}' on process '{}'", (Object)name, (Object)processDesc.getName());
        throw new IllegalStateException("No form for task with id " + taskId + " found");
    }

    protected List<UIFormProvider> collectFormProviders(FormManagerService formManagerService) {
        ArrayList<UIFormProvider> uiFormProviders = new ArrayList<UIFormProvider>();
        for (UIFormProvider formProvider : formProviders) {
            formProvider.configure(formManagerService);
            uiFormProviders.add(formProvider);
        }
        Collections.sort(uiFormProviders, new Comparator<UIFormProvider>(){

            @Override
            public int compare(UIFormProvider e1, UIFormProvider e2) {
                return Integer.valueOf(e1.getPriority()).compareTo(e2.getPriority());
            }
        });
        return uiFormProviders;
    }
}

