/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.form;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringEscapeUtils;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.form.provider.AbstractFormProvider;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.Task;
import org.kie.server.services.jbpm.ui.api.UIFormProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InMemoryFormProvider
extends AbstractFormProvider
implements UIFormProvider {
    public static final String NODE_FORM = "form";
    public static final String NODE_FIELD = "field";
    public static final String NODE_PROPERTY = "property";
    public static final String NODE_DATA_HOLDER = "dataHolder";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_TYPE = "type";
    public static final List<String> ATTR_LANG_NAMES = Arrays.asList("label", "errorMessage", "title");
    public static final String SUB_FORM_TYPE = "Subform";
    public static final String MULTI_SUB_FORM_TYPE = "MultipleSubform";

    @Override
    public void configure(FormManagerService formManagerService) {
        this.setFormManagerService(formManagerService);
    }

    @Override
    public String render(String name, ProcessDefinition process, Map<String, Object> renderContext) {
        if (!(process instanceof ProcessAssetDesc)) {
            return null;
        }
        String templateString = this.formManagerService.getFormByKey(process.getDeploymentId(), process.getId());
        if (templateString == null) {
            templateString = this.formManagerService.getFormByKey(process.getDeploymentId(), process.getId() + this.getFormSuffix());
        }
        if (templateString == null || templateString.isEmpty()) {
            return null;
        }
        String lang = (String)renderContext.get("lang");
        templateString = this.filterXML(templateString, lang, process.getDeploymentId(), null, null);
        return templateString;
    }

    @Override
    public String render(String name, Task task, ProcessDefinition process, Map<String, Object> renderContext) {
        if (task == null) {
            return null;
        }
        String lookupName = this.getTaskFormName(task);
        if (lookupName == null || lookupName.isEmpty()) {
            return null;
        }
        String templateString = this.formManagerService.getFormByKey(task.getTaskData().getDeploymentId(), lookupName);
        if (templateString == null || templateString.isEmpty()) {
            return null;
        }
        HashMap inputs = new HashMap();
        Map m = (Map)renderContext.get("inputs");
        if (m != null) {
            inputs.putAll(m);
        }
        HashMap outputs = new HashMap();
        Map mOut = (Map)renderContext.get("outputs");
        if (mOut != null) {
            outputs.putAll(mOut);
        }
        String lang = (String)renderContext.get("lang");
        templateString = this.filterXML(templateString, lang, task.getTaskData().getDeploymentId(), inputs, outputs);
        return templateString;
    }

    protected String filterXML(String document, String lang, String deploymentId, Map inputs, Map outputs) {
        try {
            if (inputs == null) {
                inputs = Collections.emptyMap();
            }
            if (outputs == null) {
                outputs = Collections.emptyMap();
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(document.getBytes()));
            NodeList nodes = doc.getElementsByTagName(NODE_FORM);
            Node nodeForm = nodes.item(0);
            NodeList childNodes = nodeForm.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String defaultSubForm;
                Node node = childNodes.item(i);
                if (!node.getNodeName().equals(NODE_FIELD)) continue;
                String fieldType = node.getAttributes().getNamedItem(ATTR_TYPE).getNodeValue();
                if (SUB_FORM_TYPE.equals(fieldType)) {
                    String subFormContent;
                    defaultSubForm = this.findPropertyValue(node, "defaultSubform");
                    if (defaultSubForm == null || (subFormContent = this.formManagerService.getFormByKey(deploymentId, defaultSubForm)) == null) continue;
                    Document tmpSubForm = builder.parse(new ByteArrayInputStream(subFormContent.getBytes()));
                    Node firstFieldNode = tmpSubForm.getElementsByTagName(NODE_FIELD).item(0);
                    String currentNodeInputBinding = this.findPropertyValue(node, "inputBinding");
                    currentNodeInputBinding = currentNodeInputBinding.replaceAll("/", ".");
                    String currentNodeOutputBinding = this.findPropertyValue(node, "outputBinding");
                    currentNodeOutputBinding = currentNodeOutputBinding.replaceAll("/", ".");
                    String inputBindingSubForm = this.findPropertyValue(firstFieldNode, "inputBinding");
                    inputBindingSubForm = inputBindingSubForm.split("/")[0];
                    String outputBindingSubForm = this.findPropertyValue(firstFieldNode, "outputBinding");
                    outputBindingSubForm = outputBindingSubForm.split("/")[0];
                    HashMap<String, Object> subFormInputs = new HashMap<String, Object>(inputs);
                    try {
                        subFormInputs.put(inputBindingSubForm, MVELSafeHelper.getEvaluator().eval(currentNodeInputBinding, inputs));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    HashMap<String, Object> subFormOutputs = new HashMap<String, Object>(outputs);
                    try {
                        subFormOutputs.put(outputBindingSubForm, MVELSafeHelper.getEvaluator().eval(currentNodeOutputBinding, outputs));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String filtered = this.filterXML(subFormContent, lang, deploymentId, subFormInputs, subFormOutputs);
                    Document docSubForm = builder.parse(new ByteArrayInputStream(filtered.getBytes()));
                    NodeList nodesSubForm = docSubForm.getElementsByTagName(NODE_FORM);
                    Node node2 = nodesSubForm.item(0);
                    Node imported = doc.importNode(node2, true);
                    node.getParentNode().replaceChild(imported, node);
                    continue;
                }
                if (MULTI_SUB_FORM_TYPE.equals(fieldType)) {
                    Node imported;
                    Node nodeFormSubForm;
                    NodeList nodesSubForm;
                    Document docSubForm;
                    String filtered;
                    String subFormContent;
                    defaultSubForm = this.findPropertyValue(node, "defaultSubform");
                    if (defaultSubForm == null || (subFormContent = this.formManagerService.getFormByKey(deploymentId, defaultSubForm)) == null) continue;
                    String inputBinding = this.findPropertyValue(node, "inputBinding");
                    inputBinding = inputBinding.replaceAll("/", ".");
                    String outputBinding = this.findPropertyValue(node, "outputBinding");
                    outputBinding = outputBinding.replaceAll("/", ".");
                    Collection<Object> list = new ArrayList<Object>();
                    Collection listOut = new ArrayList();
                    HashMap subFormInputs = new HashMap(inputs);
                    HashMap subFormOutputs = new HashMap(outputs);
                    try {
                        list = (Collection)MVELSafeHelper.getEvaluator().eval(inputBinding, inputs);
                    }
                    catch (Exception e) {
                        list.add(new Object());
                    }
                    try {
                        listOut = (Collection)MVELSafeHelper.getEvaluator().eval(outputBinding, outputs);
                    }
                    catch (Exception e) {
                        list.add(new Object());
                    }
                    Document tmpSubForm = builder.parse(new ByteArrayInputStream(subFormContent.getBytes()));
                    Node firstFieldNode = tmpSubForm.getElementsByTagName(NODE_FIELD).item(0);
                    String inputBindingSubForm = this.findPropertyValue(firstFieldNode, "inputBinding");
                    inputBindingSubForm = inputBindingSubForm.split("/")[0];
                    String outputBindingSubForm = this.findPropertyValue(firstFieldNode, "outputBinding");
                    outputBindingSubForm = outputBindingSubForm.split("/")[0];
                    for (Object e : list) {
                        subFormInputs.put(inputBindingSubForm, e);
                        filtered = this.filterXML(subFormContent, lang, deploymentId, subFormInputs, subFormOutputs);
                        docSubForm = builder.parse(new ByteArrayInputStream(filtered.getBytes()));
                        nodesSubForm = docSubForm.getElementsByTagName(NODE_FORM);
                        nodeFormSubForm = nodesSubForm.item(0);
                        imported = doc.importNode(nodeFormSubForm, true);
                        node.getParentNode().appendChild(imported);
                    }
                    for (Object e : listOut) {
                        subFormOutputs.put(outputBindingSubForm, e);
                        filtered = this.filterXML(subFormContent, lang, deploymentId, Collections.emptyMap(), subFormOutputs);
                        docSubForm = builder.parse(new ByteArrayInputStream(filtered.getBytes()));
                        nodesSubForm = docSubForm.getElementsByTagName(NODE_FORM);
                        nodeFormSubForm = nodesSubForm.item(0);
                        imported = doc.importNode(nodeFormSubForm, true);
                        node.getParentNode().appendChild(imported);
                    }
                    node.getParentNode().removeChild(node);
                    continue;
                }
                NodeList fieldPropsNodes = node.getChildNodes();
                for (int j = 0; j < fieldPropsNodes.getLength(); ++j) {
                    Node nodeFieldProp = fieldPropsNodes.item(j);
                    if (!nodeFieldProp.getNodeName().equals(NODE_PROPERTY)) continue;
                    String propName = nodeFieldProp.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                    String value = StringEscapeUtils.unescapeXml((String)nodeFieldProp.getAttributes().getNamedItem(ATTR_VALUE).getNodeValue());
                    if (inputs != null && propName != null && value != null && "inputBinding".equals(propName)) {
                        if (value.isEmpty()) continue;
                        value = value.replaceAll("/", ".");
                        try {
                            Object actualValue2 = MVELSafeHelper.getEvaluator().eval(value, inputs);
                            nodeFieldProp.getAttributes().getNamedItem(ATTR_VALUE).setNodeValue(String.valueOf(actualValue2));
                        }
                        catch (Exception actualValue2) {}
                        continue;
                    }
                    if (outputs != null && propName != null && value != null && "outputBinding".equals(propName)) {
                        if (value.isEmpty()) continue;
                        value = value.replaceAll("/", ".");
                        try {
                            Object actualValue = MVELSafeHelper.getEvaluator().eval(value, outputs);
                            nodeFieldProp.getAttributes().getNamedItem(ATTR_VALUE).setNodeValue(String.valueOf(actualValue));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (propName == null || value == null || !ATTR_LANG_NAMES.contains(propName)) continue;
                    this.filterProperty(nodeFieldProp, lang, value);
                }
            }
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            document = writer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return document;
    }

    private void filterProperty(Node property, String lang, String value) {
        String label = this.getLabel(lang, value);
        property.getAttributes().getNamedItem(ATTR_VALUE).setNodeValue(label);
    }

    private String getLabel(String lang, String value) {
        value = value.replaceAll("quot;", "\"");
        String pattern = "(\"[a-z]*\",\"[a-z]*\")";
        HashMap<String, String> langWord = new HashMap<String, String>();
        for (String s2 : value.split(pattern)) {
            String[] keyVal = s2.replaceAll("\"", "").split(",");
            if (keyVal.length != 2) continue;
            langWord.put(keyVal[0], keyVal[1]);
        }
        String response = (String)langWord.get(lang);
        if (response == null || response.isEmpty()) {
            response = (String)langWord.get("en");
        }
        return response;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    protected String getFormExtension() {
        return ".form";
    }

    protected String findPropertyValue(Node node, String propertyName) {
        NodeList fieldPropsNodes = node.getChildNodes();
        for (int j = 0; j < fieldPropsNodes.getLength(); ++j) {
            Node nodeFieldProp = fieldPropsNodes.item(j);
            if (!nodeFieldProp.getNodeName().equals(NODE_PROPERTY)) continue;
            String propName = nodeFieldProp.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
            String value = StringEscapeUtils.unescapeXml((String)nodeFieldProp.getAttributes().getNamedItem(ATTR_VALUE).getNodeValue());
            if (!propertyName.equals(propName)) continue;
            return value;
        }
        return null;
    }
}

