/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.img;

import java.util.Iterator;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.runtime.KieContainer;

public class ImageReference {
    private static final String SVG_SUFFIX = "-svg.svg";
    private static final String DEFAULT_KBASE_NAME = "defaultKieBase";
    private InternalKieModule kieModule;

    public ImageReference(KieContainer kieContainer, String kieBaseName) {
        if (kieBaseName == null || kieBaseName.isEmpty()) {
            KieBaseModel defaultKBaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
            kieBaseName = defaultKBaseModel != null ? defaultKBaseModel.getName() : DEFAULT_KBASE_NAME;
        }
        this.kieModule = (InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase(kieBaseName);
    }

    public byte[] getImageContent(String location, String name) {
        byte[] data;
        block1: {
            InternalKieModule depKieModule;
            data = this.seek(location, name, this.kieModule);
            if (data != null || this.kieModule.getKieDependencies() == null) break block1;
            Iterator iterator = this.kieModule.getKieDependencies().values().iterator();
            while (iterator.hasNext() && (data = this.seek(location, name, depKieModule = (InternalKieModule)iterator.next())) == null) {
            }
        }
        return data;
    }

    protected byte[] seek(String location, String name, InternalKieModule kieModule) {
        byte[] data = kieModule.getBytes(location + name + SVG_SUFFIX);
        if (data == null) {
            data = kieModule.getBytes(name + SVG_SUFFIX);
        }
        return data;
    }
}

