/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.svg.SVGImageProcessor;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.jbpm.ui.img.ImageReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(ImageServiceBase.class);
    private RuntimeDataService dataService;
    private Map<String, ImageReference> imageReferenceMap;
    private KieServerRegistry registry;

    public ImageServiceBase(RuntimeDataService dataService, Map<String, ImageReference> imageReferenceMap, KieServerRegistry registry) {
        this.dataService = dataService;
        this.imageReferenceMap = imageReferenceMap;
        this.registry = registry;
    }

    private byte[] getProcessImageAsBytes(String containerId, String processId) {
        byte[] imageSVG;
        ProcessDefinition procDef = this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId);
        if (procDef == null) {
            throw new IllegalArgumentException("No process found for " + processId + " within container " + containerId);
        }
        String location = "";
        if (procDef.getPackageName() != null && !procDef.getPackageName().trim().isEmpty()) {
            location = procDef.getPackageName().replaceAll("\\.", "/") + "/";
        }
        if ((imageSVG = this.imageReferenceMap.get(containerId).getImageContent(location, processId)) == null) {
            logger.warn("Could not find SVG image file for process '" + processId + "' within container " + containerId);
            return null;
        }
        return imageSVG;
    }

    public String getProcessImage(String containerId, String processId) {
        containerId = this.registry.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        String imageSVGString = null;
        byte[] imageSVG = this.getProcessImageAsBytes(containerId, processId);
        if (imageSVG != null) {
            try {
                imageSVGString = new String(imageSVG, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.debug("UnsupportedEncodingException while building process image due to {}", (Object)e.getMessage());
            }
        }
        return imageSVGString;
    }

    public String getActiveProcessImage(String containerId, long procInstId) {
        ProcessInstanceDesc instance = this.dataService.getProcessInstanceById(procInstId);
        if (instance == null) {
            throw new ProcessInstanceNotFoundException("No instance found for process instance id " + procInstId);
        }
        String imageSVGString = null;
        byte[] imageSVG = this.getProcessImageAsBytes(instance.getDeploymentId(), instance.getProcessId());
        if (imageSVG != null) {
            Collection activeLogs = this.dataService.getProcessInstanceHistoryActive(procInstId, new QueryContext(Integer.valueOf(0), Integer.valueOf(1000)));
            Collection completedLogs = this.dataService.getProcessInstanceHistoryCompleted(procInstId, new QueryContext(Integer.valueOf(0), Integer.valueOf(1000)));
            HashMap<Long, String> active = new HashMap<Long, String>();
            ArrayList<String> completed = new ArrayList<String>();
            for (NodeInstanceDesc activeNode : activeLogs) {
                active.put(activeNode.getId(), activeNode.getNodeId());
            }
            for (NodeInstanceDesc completeNode : completedLogs) {
                completed.add(completeNode.getNodeId());
                active.remove(completeNode.getId());
            }
            ByteArrayInputStream svgStream = new ByteArrayInputStream(imageSVG);
            imageSVGString = SVGImageProcessor.transform((InputStream)svgStream, completed, new ArrayList(active.values()));
            return imageSVGString;
        }
        throw new IllegalArgumentException("No process found for " + instance.getProcessId() + " within container " + containerId);
    }
}

