/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.kie.api.runtime.KieContainer;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.jbpm.ui.FormServiceBase;
import org.kie.server.services.jbpm.ui.ImageServiceBase;
import org.kie.server.services.jbpm.ui.JBPMUIKieContainerCommandServiceImpl;
import org.kie.server.services.jbpm.ui.img.ImageReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMUIKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "jBPM-UI";
    private static final Logger logger = LoggerFactory.getLogger(JBPMUIKieServerExtension.class);
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.jbpm.ui.server.ext.disabled", "false"));
    private static final Boolean jbpmDisabled = Boolean.parseBoolean(System.getProperty("org.jbpm.server.ext.disabled", "false"));
    private List<Object> services = new ArrayList<Object>();
    private boolean initialized = false;
    private ConcurrentMap<String, ImageReference> imageReferences = new ConcurrentHashMap<String, ImageReference>();
    private KieServerRegistry registry;
    private FormServiceBase formServiceBase;
    private ImageServiceBase imageServiceBase;
    private DeploymentService deploymentService;
    private KieContainerCommandService kieContainerCommandService;

    public boolean isActive() {
        return disabled == false && jbpmDisabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.registry = registry;
        KieServerExtension jbpmExtension = registry.getServerExtension("jBPM");
        if (jbpmExtension == null) {
            this.initialized = false;
            logger.warn("jBPM extension not found, jBPM UI cannot work without jBPM extension, disabling itself");
            return;
        }
        List jbpmServices = jbpmExtension.getServices();
        RuntimeDataService runtimeDataService = null;
        DefinitionService definitionService = null;
        UserTaskService userTaskService = null;
        FormManagerService formManagerService = null;
        for (Object object : jbpmServices) {
            if (object == null) continue;
            if (RuntimeDataService.class.isAssignableFrom(object.getClass())) {
                runtimeDataService = (RuntimeDataService)object;
                continue;
            }
            if (DefinitionService.class.isAssignableFrom(object.getClass())) {
                definitionService = (DefinitionService)object;
                continue;
            }
            if (UserTaskService.class.isAssignableFrom(object.getClass())) {
                userTaskService = (UserTaskService)object;
                continue;
            }
            if (FormManagerService.class.isAssignableFrom(object.getClass())) {
                formManagerService = (FormManagerService)object;
                continue;
            }
            if (!DeploymentService.class.isAssignableFrom(object.getClass())) continue;
            this.deploymentService = (DeploymentService)object;
        }
        this.formServiceBase = new FormServiceBase(definitionService, runtimeDataService, userTaskService, formManagerService, registry);
        this.imageServiceBase = new ImageServiceBase(runtimeDataService, this.imageReferences, registry);
        this.services.add(this.formServiceBase);
        this.services.add(this.imageServiceBase);
        this.kieContainerCommandService = new JBPMUIKieContainerCommandServiceImpl(null, this.formServiceBase, this.imageServiceBase);
        this.initialized = true;
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        if (!this.initialized) {
            return;
        }
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        if (!this.initialized) {
            return;
        }
        try {
            String kieBaseName = ((KModuleDeploymentUnit)this.deploymentService.getDeployedUnit(id).getDeploymentUnit()).getKbaseName();
            KieContainer kieContainer = kieContainerInstance.getKieContainer();
            this.imageReferences.putIfAbsent(id, new ImageReference(kieContainer, kieBaseName));
        }
        catch (Exception e) {
            logger.warn("Unable to create image reference for container {} due to {}", (Object)id, (Object)e.getMessage());
        }
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        this.disposeContainer(id, kieContainerInstance, parameters);
        this.createContainer(id, kieContainerInstance, parameters);
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        if (!this.initialized) {
            return;
        }
        this.imageReferences.remove(id);
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        if (!this.initialized) {
            return appComponentsList;
        }
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        Object[] services = new Object[]{this.formServiceBase, this.imageServiceBase, this.registry};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (!this.initialized) {
            return null;
        }
        if (serviceType.isAssignableFrom(this.kieContainerCommandService.getClass())) {
            return (T)this.kieContainerCommandService;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "BPM-UI";
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 10;
    }

    public String toString() {
        return "jBPM-UI KIE Server extension";
    }
}

