/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.form;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.form.provider.AbstractFormProvider;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.Task;
import org.kie.server.services.jbpm.ui.FormServiceBase;
import org.kie.server.services.jbpm.ui.api.UIFormProvider;

public class RemoteKieFormsProvider
extends AbstractFormProvider
implements UIFormProvider {
    public static final String SUBFORM = "SubForm";
    public static final String SUBFORM_FORM_PROPERTY = "nestedForm";
    public static final String MULTIPLE_SUBFORM = "MultipleSubForm";
    public static final String MULTIPLE_SUBFORM_CREATION_FORM_PROPERTY = "creationForm";
    public static final String MULTIPLE_SUBFORM_EDITION_FORM_PROPERTY = "editionForm";
    protected FormManagerService formManagerService;
    protected JsonParser parser = new JsonParser();
    protected Gson gson = new Gson();

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public String getType() {
        return FormServiceBase.FormType.FORM_TYPE.getName();
    }

    @Override
    public void configure(FormManagerService formManagerService) {
        this.formManagerService = formManagerService;
    }

    @Override
    public String render(String name, ProcessDefinition process, Map<String, Object> renderContext) {
        if (!(process instanceof ProcessAssetDesc)) {
            return null;
        }
        return this.render(process.getId() + this.getFormSuffix(), process.getDeploymentId());
    }

    @Override
    public String render(String name, Task task, ProcessDefinition process, Map<String, Object> renderContext) {
        String lookupName = this.getTaskFormName(task);
        if (lookupName == null || lookupName.isEmpty()) {
            return null;
        }
        return this.render(lookupName, task.getTaskData().getDeploymentId());
    }

    protected String render(String formName, String deploymentId) {
        String formContent = this.formManagerService.getFormByKey(deploymentId, formName);
        if (!StringUtils.isEmpty((CharSequence)formContent)) {
            return this.generateRenderingContextString(formContent, this.formManagerService.getAllFormsByDeployment(deploymentId));
        }
        return null;
    }

    protected String generateRenderingContextString(String formContent, Map<String, String> availableForms) {
        HashMap<String, Object> contextForms = new HashMap<String, Object>();
        Collection<String> result = availableForms.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith(this.getFormExtension())).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())).values();
        this.parseFormContent(this.parser.parse(formContent).getAsJsonObject(), contextForms, result);
        return this.gson.toJson(contextForms.values());
    }

    protected void parseFormContent(JsonObject jsonForm, Map<String, Object> contextForms, Collection<String> availableForms) {
        String id = jsonForm.get("id").getAsString();
        if (!contextForms.containsKey(id)) {
            contextForms.put(id, jsonForm);
        }
        JsonArray fields = jsonForm.get("fields").getAsJsonArray();
        fields.forEach(jsonElement -> {
            JsonObject object = jsonElement.getAsJsonObject();
            if (object != null) {
                String code = object.get("code").getAsString();
                if (SUBFORM.equals(code)) {
                    String id1 = object.get(SUBFORM_FORM_PROPERTY).getAsString();
                    this.parseFormContent(id1, contextForms, availableForms);
                } else if (MULTIPLE_SUBFORM.equals(code)) {
                    String id1 = object.get(MULTIPLE_SUBFORM_CREATION_FORM_PROPERTY).getAsString();
                    this.parseFormContent(id1, contextForms, availableForms);
                    id1 = object.get(MULTIPLE_SUBFORM_EDITION_FORM_PROPERTY).getAsString();
                    this.parseFormContent(id1, contextForms, availableForms);
                }
            }
        });
    }

    protected void parseFormContent(String formId, Map<String, Object> contextForms, Collection<String> availableForms) {
        JsonObject jsonForm;
        if (!StringUtils.isEmpty((CharSequence)formId) && !contextForms.containsKey(formId) && (jsonForm = this.findForm(formId, availableForms)) != null) {
            this.parseFormContent(jsonForm, contextForms, availableForms);
        }
    }

    protected JsonObject findForm(String id, Collection<String> availableForms) {
        Iterator<String> it = availableForms.iterator();
        while (it.hasNext()) {
            String formContent = it.next();
            JsonObject jsonForm = this.parser.parse(formContent).getAsJsonObject();
            if (!id.equals(jsonForm.get("id").getAsString())) continue;
            it.remove();
            return jsonForm;
        }
        return null;
    }

    protected String getFormExtension() {
        return ".frm";
    }
}

