/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.img;

import java.io.File;
import java.util.Iterator;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieContainer;

public class ImageReference {
    private static final String SVG_SUFFIX = "-svg.svg";
    private static final String DEFAULT_KBASE_NAME = "defaultKieBase";
    private InternalKieModule kieModule;
    private KieContainer kieContainer;
    private String kieBaseName;

    public ImageReference(KieContainer kieContainer, String kieBaseName) {
        this.kieContainer = kieContainer;
        if (kieBaseName == null || kieBaseName.isEmpty()) {
            KieBaseModel defaultKBaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
            kieBaseName = defaultKBaseModel != null ? defaultKBaseModel.getName() : DEFAULT_KBASE_NAME;
        }
        this.kieModule = (InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase(kieBaseName);
        this.kieBaseName = kieBaseName;
    }

    public byte[] getImageContent(String location, String name) {
        byte[] data;
        block3: {
            InternalKieModule depKieModule;
            String sourcePath;
            Process process = this.kieContainer.getKieBase(this.kieBaseName).getProcess(name);
            if (process != null && (sourcePath = process.getResource().getSourcePath()) != null) {
                String processDirectory = new File(sourcePath).getParent();
                processDirectory = processDirectory == null ? "" : processDirectory + "/";
                byte[] data2 = this.seek(processDirectory, name, this.kieModule);
                if (data2 != null) {
                    return data2;
                }
                location = processDirectory;
            }
            if ((data = this.seek(location, name, this.kieModule)) != null || this.kieModule.getKieDependencies() == null) break block3;
            Iterator iterator = this.kieModule.getKieDependencies().values().iterator();
            while (iterator.hasNext() && (data = this.seek(location, name, depKieModule = (InternalKieModule)iterator.next())) == null) {
            }
        }
        return data;
    }

    protected byte[] seek(String location, String name, InternalKieModule kieModule) {
        byte[] data = kieModule.getBytes(location + name + SVG_SUFFIX);
        if (data == null) {
            data = kieModule.getBytes(name + SVG_SUFFIX);
        }
        return data;
    }
}

