/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.form.render;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.server.services.jbpm.ui.form.render.FormReader;
import org.kie.server.services.jbpm.ui.form.render.model.FormField;
import org.kie.server.services.jbpm.ui.form.render.model.FormInstance;
import org.kie.server.services.jbpm.ui.form.render.model.FormLayout;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutColumn;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutItem;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutRow;

public class FormReaderTest {
    @Test
    public void testReadBasicForm() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/hiring-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        Assertions.assertThat((String)form.getId()).isEqualTo((Object)"011ebd63-f9b5-4057-b5ff-999c1c7e5080");
        Assertions.assertThat((String)form.getName()).isEqualTo((Object)"hiring-taskform.frm");
        Assertions.assertThat((List)form.getFields()).hasSize(1);
        FormField field = (FormField)form.getFields().get(0);
        this.assertField(field, "field_2225717094101704E12", "name", "TextBox", "Candidate Name", 100, "name", "Enter your name", "java.lang.String", false, false);
        FormLayout layout = form.getLayout();
        Assertions.assertThat((Object)layout).isNotNull();
        Assertions.assertThat((List)layout.getRows()).hasSize(1);
        LayoutRow row = (LayoutRow)layout.getRows().get(0);
        Assertions.assertThat((List)row.getColumns()).hasSize(1);
        LayoutColumn column = (LayoutColumn)row.getColumns().get(0);
        this.assertColumn(column, "12", 1, "011ebd63-f9b5-4057-b5ff-999c1c7e5080", "field_2225717094101704E12");
    }

    @Test
    public void testReadBasicFormWithModel() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/property-form.json"));
        Assertions.assertThat((Object)form).isNotNull();
        Assertions.assertThat((String)form.getId()).isEqualTo((Object)"2aeaf281-71e1-45a5-9ab3-0abd855d924e");
        Assertions.assertThat((String)form.getName()).isEqualTo((Object)"Property");
        Assertions.assertThat((Object)form.getModel()).isNotNull();
        Assertions.assertThat((String)form.getModel().getClassName()).isEqualTo((Object)"com.myspace.mortgage_app.Property");
        Assertions.assertThat((String)form.getModel().getName()).isEqualTo((Object)"property");
        Assertions.assertThat((List)form.getFields()).hasSize(4);
        FormField field = (FormField)form.getFields().get(0);
        this.assertField(field, "field_815717729253767E11", "age", "IntegerBox", "Age of property", 100, "age", "Age of property", "java.lang.Integer", false, false);
        field = (FormField)form.getFields().get(1);
        this.assertField(field, "field_236289653097941E11", "address", "TextBox", "Address of property", 100, "address", "Address of property", "java.lang.String", false, false);
        field = (FormField)form.getFields().get(2);
        this.assertField(field, "field_9471909295199063E11", "locale", "TextBox", "Locale", 100, "locale", "Locale", "java.lang.String", false, false);
        field = (FormField)form.getFields().get(3);
        this.assertField(field, "field_4113393327260706E12", "saleprice", "IntegerBox", "Sale Price", 100, "saleprice", "Sale Price", "java.lang.Integer", false, false);
        FormLayout layout = form.getLayout();
        Assertions.assertThat((Object)layout).isNotNull();
        Assertions.assertThat((List)layout.getRows()).hasSize(4);
        LayoutRow row = (LayoutRow)layout.getRows().get(0);
        Assertions.assertThat((List)row.getColumns()).hasSize(1);
        LayoutColumn column = (LayoutColumn)row.getColumns().get(0);
        this.assertColumn(column, "12", 1, "2aeaf281-71e1-45a5-9ab3-0abd855d924e", "field_815717729253767E11");
        row = (LayoutRow)layout.getRows().get(1);
        Assertions.assertThat((List)row.getColumns()).hasSize(1);
        column = (LayoutColumn)row.getColumns().get(0);
        this.assertColumn(column, "12", 1, "2aeaf281-71e1-45a5-9ab3-0abd855d924e", "field_236289653097941E11");
        row = (LayoutRow)layout.getRows().get(2);
        Assertions.assertThat((List)row.getColumns()).hasSize(1);
        column = (LayoutColumn)row.getColumns().get(0);
        this.assertColumn(column, "12", 1, "2aeaf281-71e1-45a5-9ab3-0abd855d924e", "field_9471909295199063E11");
        row = (LayoutRow)layout.getRows().get(3);
        Assertions.assertThat((List)row.getColumns()).hasSize(1);
        column = (LayoutColumn)row.getColumns().get(0);
        this.assertColumn(column, "12", 1, "2aeaf281-71e1-45a5-9ab3-0abd855d924e", "field_4113393327260706E12");
    }

    protected void assertField(FormField field, String id, String binding, String code, String label, int maxLength, String name, String placeHolder, String type, boolean readOnly, boolean required) {
        Assertions.assertThat((String)field.getId()).isEqualTo((Object)id);
        Assertions.assertThat((String)field.getBinding()).isEqualTo((Object)binding);
        Assertions.assertThat((String)field.getCode()).isEqualTo((Object)code);
        Assertions.assertThat((String)field.getLabel()).isEqualTo((Object)label);
        Assertions.assertThat((long)field.getMaxLength()).isEqualTo((long)maxLength);
        Assertions.assertThat((String)field.getName()).isEqualTo((Object)name);
        Assertions.assertThat((String)field.getPlaceHolder()).isEqualTo((Object)placeHolder);
        Assertions.assertThat((String)field.getType()).isEqualTo((Object)type);
        Assertions.assertThat((boolean)field.isReadOnly()).isEqualTo(readOnly);
        Assertions.assertThat((boolean)field.isRequired()).isEqualTo(required);
    }

    protected void assertColumn(LayoutColumn column, String span, int itemSize, String formId, String fieldId) {
        Assertions.assertThat((String)column.getSpan()).isEqualTo((Object)span);
        Assertions.assertThat((List)column.getItems()).hasSize(itemSize);
        LayoutItem item = (LayoutItem)column.getItems().get(0);
        Assertions.assertThat((String)item.getFormId()).isEqualTo((Object)formId);
        Assertions.assertThat((String)item.getFieldId()).isEqualTo((Object)fieldId);
    }
}

