/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.util.HashMap;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.Test;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.ui.FormRendererBase;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormRendererBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(FormRendererBaseTest.class);

    @Test
    public void testGenerateDefaultForm() {
        DefinitionService definitionService = (DefinitionService)Mockito.mock(DefinitionService.class);
        UserTaskService userTaskService = (UserTaskService)Mockito.mock(UserTaskService.class);
        FormManagerService formManagerService = (FormManagerService)Mockito.mock(FormManagerService.class);
        CaseRuntimeDataService caseRuntimeDataService = (CaseRuntimeDataService)Mockito.mock(CaseRuntimeDataService.class);
        KieServerRegistry registry = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        ProcessDefinition processDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)processDefinition.getId()).thenReturn((Object)"testprocess");
        Mockito.when((Object)processDefinition.getName()).thenReturn((Object)"Test Process");
        FormRendererBase rendererBase = new FormRendererBase(definitionService, userTaskService, formManagerService, caseRuntimeDataService, registry);
        Mockito.when((Object)registry.getContainerId((String)Mockito.any(), (ContainerLocator)Mockito.any())).thenReturn((Object)"test");
        Mockito.when((Object)definitionService.getProcessDefinition((String)Mockito.eq((Object)"test"), (String)Mockito.eq((Object)"test-process"))).thenReturn((Object)processDefinition);
        String result = rendererBase.getProcessRenderedForm("patternfly", "test", "test-process");
        logger.debug("Form content is '{}'", (Object)result);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).isNotNull()).isNotEmpty();
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/patternfly/css/patternfly.min.css\" rel=\"stylesheet\">"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/patternfly/css/patternfly-additions.min.css\" rel=\"stylesheet\">"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/patternfly/js/jquery.min.js\"></script>"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/patternfly/js/patternfly.min.js\"></script>"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/js/kieserver-ui.js\"></script>"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"<h3 class=\"panel-title\">Default form - Test Process</h3>"});
    }

    @Test
    public void testGenerateDefaultFormWithVariables() {
        DefinitionService definitionService = (DefinitionService)Mockito.mock(DefinitionService.class);
        UserTaskService userTaskService = (UserTaskService)Mockito.mock(UserTaskService.class);
        FormManagerService formManagerService = (FormManagerService)Mockito.mock(FormManagerService.class);
        CaseRuntimeDataService caseRuntimeDataService = (CaseRuntimeDataService)Mockito.mock(CaseRuntimeDataService.class);
        KieServerRegistry registry = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        ProcessDefinition processDefinition = (ProcessDefinition)Mockito.mock(ProcessDefinition.class);
        Mockito.when((Object)processDefinition.getId()).thenReturn((Object)"testprocess");
        Mockito.when((Object)processDefinition.getName()).thenReturn((Object)"Test Process");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("name", "java.lang.String");
        variables.put("age", "java.lang.Integer");
        variables.put("maried", "java.lang.Boolean");
        Mockito.when((Object)processDefinition.getProcessVariables()).thenReturn(variables);
        FormRendererBase rendererBase = new FormRendererBase(definitionService, userTaskService, formManagerService, caseRuntimeDataService, registry);
        Mockito.when((Object)registry.getContainerId((String)Mockito.any(), (ContainerLocator)Mockito.any())).thenReturn((Object)"test");
        Mockito.when((Object)definitionService.getProcessDefinition((String)Mockito.eq((Object)"test"), (String)Mockito.eq((Object)"test-process"))).thenReturn((Object)processDefinition);
        String result = rendererBase.getProcessRenderedForm("patternfly", "test", "test-process");
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/patternfly/css/patternfly.min.css\" rel=\"stylesheet\">"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/patternfly/css/patternfly-additions.min.css\" rel=\"stylesheet\">"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/patternfly/js/jquery.min.js\"></script>"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/patternfly/js/patternfly.min.js\"></script>"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"/files/js/kieserver-ui.js\"></script>"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"<h3 class=\"panel-title\">Default form - Test Process</h3>"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"<input name=\"maried\" type=\"checkbox\" class=\"form-control\" "});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"<input name=\"name\" type=\"text\" class=\"form-control\" "});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"<input name=\"age\" type=\"text\" class=\"form-control\" "});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"<button type=\"button\" class=\"btn btn-primary\" onclick=\"startProcess(this);\">Submit</button>"});
    }
}

