/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.form.render;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.server.services.jbpm.ui.form.render.BootstrapFormRenderer;
import org.kie.server.services.jbpm.ui.form.render.FormReader;
import org.kie.server.services.jbpm.ui.form.render.FormRenderer;
import org.kie.server.services.jbpm.ui.form.render.PatternflyFormRenderer;
import org.kie.server.services.jbpm.ui.form.render.data.Item;
import org.kie.server.services.jbpm.ui.form.render.model.FormInstance;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class FormRendererTest {
    @Parameterized.Parameter(value=0)
    public FormRenderer renderer;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        PatternflyFormRenderer patternfly = new PatternflyFormRenderer("file://" + new File("src/main/resources").getAbsolutePath(), "/form-templates-providers");
        ArrayList<Object[]> parameterData = new ArrayList<Object[]>(Arrays.asList(new Object[][]{{patternfly}}));
        BootstrapFormRenderer bootstrap = new BootstrapFormRenderer("file://" + new File("src/main/resources").getAbsolutePath(), "/form-templates-providers");
        parameterData.addAll(Arrays.asList(new Object[][]{{bootstrap}}));
        return parameterData;
    }

    @Test
    public void testRenderOfBasicFormNoData() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/hiring-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        ProcessDefinition processDefinition = this.newProcessDefinition("");
        String renderedForm = this.renderer.renderProcess("", processDefinition, form);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfBasicFormNoData.html", renderedForm);
    }

    @Test
    public void testRenderOfBasicFormMultipleRowsNoData() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/createProposal-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        ProcessDefinition processDefinition = this.newProcessDefinition("");
        String renderedForm = this.renderer.renderProcess("", processDefinition, form);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfBasicFormMultipleRowsNoData.html", renderedForm);
    }

    @Test
    public void testRenderOfBasicTaskFormNoData() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/createProposal-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        HashMap<String, Integer> inputs = new HashMap<String, Integer>();
        inputs.put("offering", 1000);
        inputs.put("tech_score", 123);
        HashMap outputs = new HashMap();
        Task task = this.newTask(0L, "Ready");
        String renderedForm = this.renderer.renderTask("", task, form, inputs, outputs);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfBasicTaskFormNoData.html", renderedForm);
    }

    @Test
    public void testRenderOfBasicFormCustomData() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/property-form.json"));
        Assertions.assertThat((Object)form).isNotNull();
        ProcessDefinition processDefinition = this.newProcessDefinition("");
        String renderedForm = this.renderer.renderProcess("", processDefinition, form);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfBasicFormCustomData.html", renderedForm);
    }

    @Test
    public void testRenderOfBasicFormCustomDataApplicant() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/applicant-form.json"));
        Assertions.assertThat((Object)form).isNotNull();
        ProcessDefinition processDefinition = this.newProcessDefinition("");
        String renderedForm = this.renderer.renderProcess("", processDefinition, form);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfBasicFormCustomDataApplicant.html", renderedForm);
    }

    @Test
    public void testRenderOfNestedFormCustomData() {
        FormReader reader = new FormReader();
        FormInstance applicant = reader.readFromStream(this.getClass().getResourceAsStream("/applicant-form.json"));
        Assertions.assertThat((Object)applicant).isNotNull();
        FormInstance property = reader.readFromStream(this.getClass().getResourceAsStream("/property-form.json"));
        Assertions.assertThat((Object)property).isNotNull();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/application-form.json"));
        Assertions.assertThat((Object)form).isNotNull();
        form.addNestedForm(applicant);
        form.addNestedForm(property);
        ProcessDefinition processDefinition = this.newProcessDefinition("");
        String renderedForm = this.renderer.renderProcess("", processDefinition, form);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfNestedFormCustomData.html", renderedForm);
    }

    @Test
    public void testRenderOfAllInOneFormCustomDataApplicant() {
        FormReader reader = new FormReader();
        FormInstance applicant = reader.readFromStream(this.getClass().getResourceAsStream("/applicant-form.json"));
        Assertions.assertThat((Object)applicant).isNotNull();
        FormInstance property = reader.readFromStream(this.getClass().getResourceAsStream("/property-form.json"));
        Assertions.assertThat((Object)property).isNotNull();
        FormInstance application = reader.readFromStream(this.getClass().getResourceAsStream("/complete-application-form.json"));
        Assertions.assertThat((Object)application).isNotNull();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/composite-form.json"));
        Assertions.assertThat((Object)form).isNotNull();
        form.addNestedForm(application);
        form.addNestedForm(applicant);
        form.addNestedForm(property);
        ProcessDefinition processDefinition = this.newProcessDefinition("");
        String renderedForm = this.renderer.renderProcess("", processDefinition, form);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfAllInOneFormCustomDataApplicant.html", renderedForm);
    }

    @Test
    public void testRenderOfBasicCaseFormNoData() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/hiring-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        CaseDefinition caseDefinition = this.newCaseDefinition("test", "admin", "owner");
        String renderedForm = this.renderer.renderCase("", caseDefinition, form);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfBasicCaseFormNoData.html", renderedForm);
    }

    @Test
    public void testRenderOfBasicFormWithSelectRadioGroup() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/various-fields-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        ProcessDefinition processDefinition = this.newProcessDefinition("");
        String renderedForm = this.renderer.renderProcess("", processDefinition, form);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfBasicFormWithSelectRadioGroup.html", renderedForm);
    }

    @Test
    public void testRenderOfBasicTaskFormWithSelectRadioGroupAndData() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/various-fields-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("selection", "another");
        inputs.put("radio", "radio2");
        inputs.put("decimal", 123.5);
        inputs.put("hwSpec_", "name####123####111####id");
        HashMap outputs = new HashMap();
        Task task = this.newTask(0L, "Ready");
        String renderedForm = this.renderer.renderTask("", task, form, inputs, outputs);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfBasicTaskFormWithSelectRadioGroupAndData.html", renderedForm);
    }

    @Test
    public void testRenderOfMultiSubFormNoData() {
        FormReader reader = new FormReader();
        FormInstance itemForm = reader.readFromStream(this.getClass().getResourceAsStream("/item-taskform.json"));
        Assertions.assertThat((Object)itemForm).isNotNull();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/order-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        form.addNestedForm(itemForm);
        ProcessDefinition processDefinition = this.newProcessDefinition("");
        String renderedForm = this.renderer.renderProcess("", processDefinition, form);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfMultiSubFormNoData.html", renderedForm);
    }

    @Test
    public void testRenderOfMultiSubFormWithData() {
        FormReader reader = new FormReader();
        FormInstance itemForm = reader.readFromStream(this.getClass().getResourceAsStream("/item-taskform.json"));
        Assertions.assertThat((Object)itemForm).isNotNull();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/order-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        form.addNestedForm(itemForm);
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(new Item("test", 10, 125.5));
        items.add(new Item("another", 4, 25.8));
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("items", items);
        inputs.put("orderNumber", "XXX-ZZZ-YYY");
        inputs.put("customer", "John");
        inputs.put("address", "Main Street");
        HashMap outputs = new HashMap();
        Task task = this.newTask(0L, "Ready");
        String renderedForm = this.renderer.renderTask("", task, form, inputs, outputs);
        Assertions.assertThat((String)renderedForm).isNotNull();
        this.writeToFile("testRenderOfMultiSubFormWithData.html", renderedForm);
    }

    @Test
    public void testRenderOfMultiSubFormWithDataAndHTMLExpression() {
        FormReader reader = new FormReader();
        FormInstance itemForm = reader.readFromStream(this.getClass().getResourceAsStream("/item-taskform.json"));
        Assertions.assertThat((Object)itemForm).isNotNull();
        FormInstance orderForm = reader.readFromStream(this.getClass().getResourceAsStream("/order-taskform.json"));
        Assertions.assertThat((Object)orderForm).isNotNull();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/add-items-taskform.json"));
        Assertions.assertThat((Object)form).isNotNull();
        form.addNestedForm(itemForm);
        form.addNestedForm(orderForm);
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(new Item("test", 10, 125.5));
        items.add(new Item("another", 4, 25.8));
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("items", items);
        inputs.put("orderNumber", "XXX-ZZZ-YYY");
        inputs.put("customer", "John");
        inputs.put("address", "Main Street");
        HashMap outputs = new HashMap();
        Task task = this.newTask(0L, "Ready");
        String renderedForm = this.renderer.renderTask("", task, form, inputs, outputs);
        Assertions.assertThat((String)renderedForm).isNotNull();
        Assertions.assertThat((String)renderedForm).contains(new CharSequence[]{"<div class=\"col-md-12\"><h2>Add items for order XXX-ZZZ-YYY</h2></div>"});
        this.writeToFile("testRenderOfMultiSubFormWithDataAndHTMLExpression.html", renderedForm);
    }

    protected void writeToFile(String fileName, String content) {
        try {
            Files.write(Paths.get("target/" + this.renderer.getName() + "_" + fileName, new String[0]), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ProcessDefinition newProcessDefinition(String processId) {
        ProcessAssetDesc definition = new ProcessAssetDesc();
        definition.setId(processId);
        return definition;
    }

    protected Task newTask(Long taskId, String taskStatus) {
        Task task = (Task)Mockito.mock(Task.class);
        TaskData taskData = (TaskData)Mockito.mock(TaskData.class);
        Mockito.when((Object)task.getId()).thenReturn((Object)taskId);
        Mockito.when((Object)task.getTaskData()).thenReturn((Object)taskData);
        Mockito.when((Object)task.getTaskData().getStatus()).thenReturn((Object)Status.valueOf((String)taskStatus));
        return task;
    }

    protected CaseDefinition newCaseDefinition(String definitionId, String ... roles) {
        CaseDefinition definition = (CaseDefinition)Mockito.mock(CaseDefinition.class);
        Mockito.when((Object)definition.getId()).thenReturn((Object)definitionId);
        ArrayList<CaseRole> caseRoles = new ArrayList<CaseRole>();
        for (String role : roles) {
            CaseRole cRole = (CaseRole)Mockito.mock(CaseRole.class);
            Mockito.when((Object)cRole.getName()).thenReturn((Object)role);
            caseRoles.add(cRole);
        }
        Mockito.when((Object)definition.getCaseRoles()).thenReturn(caseRoles);
        return definition;
    }
}

