/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.jbpm.ui.ImageServiceBase;
import org.kie.server.services.jbpm.ui.img.ImageReference;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RunWith(value=MockitoJUnitRunner.class)
public class ImageServiceBaseTest {
    @Mock
    KieServerRegistry kieServerRegistry = new KieServerRegistryImpl();
    @Mock
    RuntimeDataService dataService;
    @Mock
    ImageReference imageReference;
    @Mock
    KieServerConfig config;

    @Test
    public void testHighValueSubProcessInstanceId() {
        ImageServiceBase imageServiceBase = new ImageServiceBase();
        org.jbpm.kie.services.impl.model.NodeInstanceDesc node = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("9999", "1234", "Test node", "SubProcessNode", "test-deployment", 1001L, new Date(), "test-connection", 1, Long.valueOf(2001L), Long.valueOf(3001L), "", null, null);
        HashMap subProcessLinks = new HashMap();
        imageServiceBase.populateSubProcessLink("test", (NodeInstanceDesc)node, subProcessLinks);
        Assert.assertEquals((long)1L, (long)subProcessLinks.size());
        Assert.assertEquals((Object)"containers/test/images/processes/instances/3001", subProcessLinks.get("1234"));
    }

    @Test
    public void testIncludedViewBoxAtProcessImage() throws Exception {
        String containerId = "test-container";
        String processId = "test-processId";
        byte[] byteArray = this.getInputStreamAsByteArray(ImageServiceBaseTest.class.getResourceAsStream("/evaluation-svg.svg"));
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId)).thenReturn(Mockito.mock(ProcessDefinition.class));
        Mockito.when((Object)this.imageReference.getImageContent(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)byteArray);
        Mockito.when((Object)this.kieServerRegistry.getContainerId(Matchers.anyString(), (ContainerLocator)Matchers.any(ContainerLocator.class))).thenReturn((Object)containerId);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getConfigItemValue(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"");
        HashMap<String, ImageReference> imageReferenceMap = new HashMap<String, ImageReference>();
        imageReferenceMap.put(containerId, this.imageReference);
        ImageServiceBase imageServiceBase = new ImageServiceBase(this.dataService, imageReferenceMap, this.kieServerRegistry);
        String processImageStr = imageServiceBase.getProcessImage(containerId, "test-processId");
        Document svgDocument = this.readSVG(processImageStr);
        Assert.assertEquals((Object)"", (Object)((Element)svgDocument.getFirstChild()).getAttribute("width"));
        Assert.assertEquals((Object)"", (Object)((Element)svgDocument.getFirstChild()).getAttribute("height"));
        Assert.assertEquals((Object)"0 0 3000 2000", (Object)svgDocument.getFirstChild().getAttributes().getNamedItem("viewBox").getNodeValue());
    }

    private byte[] getInputStreamAsByteArray(InputStream inputStream) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Document readSVG(String svgContent) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        factory.setValidating(false);
        Document svgDocument = factory.createDocument("http://jbpm.org", (Reader)new StringReader(svgContent));
        return svgDocument;
    }
}

