/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.task.commands.GetUserTaskCommand;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.command.Command;
import org.kie.api.task.model.TaskData;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.jbpm.ui.FormServiceBase;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FormServiceBaseTest {
    private final String dummyForm = "{\"id\": \"30f64834-1fe6-4ffb-ba48-024bc6839d5c\", \"name\": \"form-taskform.frm\", \"fields\": [{\"maxLength\": 100,\"placeHolder\": \"Resultado\",\"id\": \"field_id\",\"name\": \"field\",\"label\": \"Field\",\"code\": \"TextBox\"}]}";
    private final String CONTAINER_ID = "test-container";
    private final String PROCESS_ID = "test-processId";
    @Mock
    KieServerRegistry kieServerRegistry = new KieServerRegistryImpl();
    @Mock
    DefinitionService definitionService;
    @Mock
    RuntimeDataService dataService;
    @Mock
    UserTaskService userTaskService;
    @Mock
    FormManagerService formManagerService;
    @Mock
    IdentityProvider identityProvider;
    @Mock
    KieServerConfig config;
    @Mock
    TaskImpl task;
    @Mock
    TaskData taskData;
    @Mock
    ProcessDefinition processDefinition;

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.kieServerRegistry.getContainerId(Matchers.anyString(), (ContainerLocator)Matchers.any(ContainerLocator.class))).thenReturn((Object)"test-container");
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.kieServerRegistry.getIdentityProvider()).thenReturn((Object)this.identityProvider);
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)"admin");
        Mockito.when((Object)this.userTaskService.execute((String)Matchers.any(), (Command)Matchers.any())).thenReturn((Object)this.task);
        Mockito.when((Object)this.task.getName()).thenReturn((Object)"task");
        Mockito.when((Object)this.task.getTaskData()).thenReturn((Object)this.taskData);
        Mockito.when((Object)this.task.getFormName()).thenReturn((Object)"form");
        Mockito.when((Object)this.taskData.getProcessId()).thenReturn((Object)"test-processId");
        Mockito.when((Object)this.taskData.getDeploymentId()).thenReturn((Object)"test-container");
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId((String)Matchers.eq((Object)"test-container"), (String)Matchers.eq((Object)"test-processId"))).thenReturn((Object)this.processDefinition);
        Mockito.when((Object)this.formManagerService.getFormByKey((String)Matchers.eq((Object)"test-container"), (String)Matchers.eq((Object)"form-taskform.frm"))).thenReturn((Object)"{\"id\": \"30f64834-1fe6-4ffb-ba48-024bc6839d5c\", \"name\": \"form-taskform.frm\", \"fields\": [{\"maxLength\": 100,\"placeHolder\": \"Resultado\",\"id\": \"field_id\",\"name\": \"field\",\"label\": \"Field\",\"code\": \"TextBox\"}]}");
    }

    @Test
    public void testGetFormDisplayTaskUsesRequestorIdentity() {
        Mockito.when((Object)this.config.getConfigItemValue((String)Matchers.eq((Object)"org.kie.server.bypass.auth.user"), Matchers.anyString())).thenReturn((Object)"false");
        FormServiceBase formServiceBase = new FormServiceBase(this.definitionService, this.dataService, this.userTaskService, this.formManagerService, this.kieServerRegistry);
        String userId = "john";
        formServiceBase.getFormDisplayTask("test-container", 1L, userId, "en_US", true, FormServiceBase.FormType.ANY.getName());
        ((KieServerRegistry)Mockito.verify((Object)this.kieServerRegistry, (VerificationMode)Mockito.times((int)1))).getIdentityProvider();
        ArgumentCaptor argument = ArgumentCaptor.forClass(GetUserTaskCommand.class);
        ((UserTaskService)Mockito.verify((Object)this.userTaskService, (VerificationMode)Mockito.times((int)1))).execute((String)Matchers.eq((Object)"test-container"), (Command)argument.capture());
        Assert.assertEquals((Object)"admin", (Object)((GetUserTaskCommand)argument.getValue()).getUserId());
    }

    @Test
    public void testGetFormDisplayTaskBypassesAuthUser() {
        Mockito.when((Object)this.config.getConfigItemValue((String)Matchers.eq((Object)"org.kie.server.bypass.auth.user"), Matchers.anyString())).thenReturn((Object)"true");
        FormServiceBase formServiceBase = new FormServiceBase(this.definitionService, this.dataService, this.userTaskService, this.formManagerService, this.kieServerRegistry);
        String userId = "john";
        formServiceBase.getFormDisplayTask("test-container", 1L, userId, "en_US", true, FormServiceBase.FormType.ANY.getName());
        ((KieServerRegistry)Mockito.verify((Object)this.kieServerRegistry, (VerificationMode)Mockito.times((int)0))).getIdentityProvider();
        ArgumentCaptor argument = ArgumentCaptor.forClass(GetUserTaskCommand.class);
        ((UserTaskService)Mockito.verify((Object)this.userTaskService, (VerificationMode)Mockito.times((int)1))).execute((String)Matchers.eq((Object)"test-container"), (Command)argument.capture());
        Assert.assertEquals((Object)"john", (Object)((GetUserTaskCommand)argument.getValue()).getUserId());
    }
}

