/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.form.render;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.document.DocumentCollection;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.Task;
import org.kie.server.services.jbpm.ui.form.render.FormReader;
import org.kie.server.services.jbpm.ui.form.render.FormRenderer;
import org.kie.server.services.jbpm.ui.form.render.model.FormField;
import org.kie.server.services.jbpm.ui.form.render.model.FormInstance;
import org.kie.server.services.jbpm.ui.form.render.model.FormLayout;
import org.kie.server.services.jbpm.ui.form.render.model.ItemOption;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutColumn;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutItem;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutRow;
import org.kie.server.services.jbpm.ui.form.render.model.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFormRenderer
implements FormRenderer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFormRenderer.class);
    public static final String MAIN_LAYOUT_TEMPLATE = "main";
    public static final String HEADER_LAYOUT_TEMPLATE = "header";
    public static final String FORM_GROUP_LAYOUT_TEMPLATE = "form-group";
    public static final String CASE_LAYOUT_TEMPLATE = "case-layout";
    public static final String PROCESS_LAYOUT_TEMPLATE = "process-layout";
    public static final String TASK_LAYOUT_TEMPLATE = "task-layout";
    public static final String TABLE_LAYOUT_TEMPLATE = "table";
    private Map<String, String> inputTypes;
    private StringTemplateLoader stringLoader = new StringTemplateLoader();
    private Configuration cfg;
    private StringTemplateLoader fieldLevelStringLoader = new StringTemplateLoader();
    private Configuration fieldLevelCfg;
    private FormReader reader = new FormReader();
    private String serverPath;
    private String resourcePath;

    public AbstractFormRenderer(String serverPath, String resources) {
        this.serverPath = serverPath;
        this.resourcePath = serverPath + resources;
        this.inputTypes = new HashMap<String, String>();
        this.inputTypes.put("TextBox", "text");
        this.inputTypes.put("IntegerBox", "text");
        this.inputTypes.put("DecimalBox", "text");
        this.inputTypes.put("TextArea", "textarea");
        this.inputTypes.put("CheckBox", "checkbox");
        this.inputTypes.put("ListBox", "select");
        this.inputTypes.put("RadioGroup", "radio");
        this.inputTypes.put("Document", "file");
        this.inputTypes.put("DatePicker", "Date");
        this.inputTypes.put("Slider", "slider");
        this.inputTypes.put("DocumentCollection", "documentCollection");
        this.inputTypes.put("MultipleSelector", "multipleSelector");
        this.inputTypes.put("MultipleInput", "multipleInput");
        this.cfg = new Configuration(Configuration.VERSION_2_3_26);
        this.cfg.setTemplateLoader((TemplateLoader)this.stringLoader);
        this.cfg.setDefaultEncoding("UTF-8");
        this.fieldLevelCfg = new Configuration(Configuration.VERSION_2_3_26);
        this.fieldLevelCfg.setTemplateLoader((TemplateLoader)this.fieldLevelStringLoader);
        this.fieldLevelCfg.setDefaultEncoding("UTF-8");
        this.loadTemplates();
    }

    @Override
    public void configure(String serverPath, String resources) {
        this.serverPath = serverPath;
        this.resourcePath = serverPath + resources;
    }

    @Override
    public String renderCase(String containerId, CaseDefinition caseDefinition, FormInstance form) {
        ArrayList<String> scriptDataList = new ArrayList<String>();
        StringBuilder jsonTemplate = new StringBuilder();
        jsonTemplate.append("{");
        this.appendRoleAssignment(caseDefinition, jsonTemplate);
        List<Object> rows = new ArrayList();
        jsonTemplate.append("'case-data' : {");
        if (form != null) {
            FormLayout layout = form.getLayout();
            this.processFormLayout(form, form, Collections.emptyMap(), Collections.emptyMap(), CASE_LAYOUT_TEMPLATE, jsonTemplate, true, scriptDataList);
            jsonTemplate.deleteCharAt(jsonTemplate.length() - 1).append("}").append("}");
            rows = layout.getRows();
        } else {
            jsonTemplate.append("}").append("}");
        }
        StringBuilder caseEndpoint = new StringBuilder();
        caseEndpoint.append(this.getServerEndpointPath()).append("/containers/").append(containerId).append("/cases/").append(caseDefinition.getId()).append("/instances");
        scriptDataList.add(this.buildFunctionWithBody("getData", "return " + jsonTemplate.toString()));
        scriptDataList.add(this.buildFunctionWithBody("getCaseEndpoint", "return '" + caseEndpoint.toString() + "';"));
        scriptDataList.add(this.buildFunctionWithBody("initializeForm", ""));
        scriptDataList.add(this.buildFunctionWithBody("endpointSuffix", "return '" + this.getEndpointSuffix() + "';"));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("roles", caseDefinition.getCaseRoles());
        parameters.put("rows", rows);
        parameters.put("renderButtons", true);
        String output = this.renderTemplate(CASE_LAYOUT_TEMPLATE, parameters);
        parameters = new HashMap();
        parameters.put(HEADER_LAYOUT_TEMPLATE, form != null ? form.getName() : "Case form");
        parameters.put("body", output);
        parameters.put("scriptData", this.buildScriptData(scriptDataList));
        parameters.put("serverPath", this.resourcePath);
        String finalOutput = this.renderTemplate(MAIN_LAYOUT_TEMPLATE, parameters);
        return finalOutput;
    }

    @Override
    public String renderProcess(String containerId, ProcessDefinition processDesc, FormInstance form) {
        ArrayList<String> scriptDataList = new ArrayList<String>();
        FormLayout layout = form.getLayout();
        StringBuilder jsonTemplate = new StringBuilder();
        jsonTemplate.append("{");
        this.processFormLayout(form, form, Collections.emptyMap(), Collections.emptyMap(), PROCESS_LAYOUT_TEMPLATE, jsonTemplate, true, scriptDataList);
        if (jsonTemplate.length() > 1) {
            jsonTemplate.deleteCharAt(jsonTemplate.length() - 1);
        }
        jsonTemplate.append("}");
        StringBuilder processEndpoint = new StringBuilder();
        processEndpoint.append(this.getServerEndpointPath()).append("/containers/").append(containerId).append("/processes/").append(processDesc.getId()).append("/instances");
        scriptDataList.add(this.buildFunctionWithBody("getData", "return " + jsonTemplate.toString()));
        scriptDataList.add(this.buildFunctionWithBody("getProcessEndpoint", "return '" + processEndpoint.toString() + "';"));
        scriptDataList.add(this.buildFunctionWithBody("initializeForm", ""));
        scriptDataList.add(this.buildFunctionWithBody("endpointSuffix", "return '" + this.getEndpointSuffix() + "';"));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rows", layout.getRows());
        parameters.put("renderButtons", true);
        String output = this.renderTemplate(PROCESS_LAYOUT_TEMPLATE, parameters);
        parameters = new HashMap();
        parameters.put(HEADER_LAYOUT_TEMPLATE, form.getName());
        parameters.put("body", output);
        parameters.put("scriptData", this.buildScriptData(scriptDataList));
        parameters.put("serverPath", this.resourcePath);
        String finalOutput = this.renderTemplate(MAIN_LAYOUT_TEMPLATE, parameters);
        return finalOutput;
    }

    @Override
    public String renderTask(String containerId, Task task, FormInstance form, Map<String, Object> inputs, Map<String, Object> outputs) {
        ArrayList<String> scriptDataList = new ArrayList<String>();
        FormLayout layout = form.getLayout();
        StringBuilder jsonTemplate = new StringBuilder();
        jsonTemplate.append("{");
        this.processFormLayout(form, form, inputs, outputs, TASK_LAYOUT_TEMPLATE, jsonTemplate, true, scriptDataList);
        if (jsonTemplate.length() > 1) {
            jsonTemplate.deleteCharAt(jsonTemplate.length() - 1);
        }
        jsonTemplate.append("}");
        StringBuilder taskEndpoint = new StringBuilder();
        taskEndpoint.append(this.getServerEndpointPath()).append("/containers/").append(containerId).append("/tasks/").append(task.getId());
        scriptDataList.add(this.buildFunctionWithBody("getData", "return " + jsonTemplate.toString()));
        scriptDataList.add(this.buildFunctionWithBody("getTaskEndpoint", "return '" + taskEndpoint.toString() + "';"));
        scriptDataList.add(this.buildFunctionWithBody("initializeForm", "taskStatus = '" + task.getTaskData().getStatus().name() + "';\n$('input[data-slider-id]').slider({});\n$('input[data-role=tagsinput').tagsinput();\ninitTaskButtons();\n"));
        scriptDataList.add(this.buildFunctionWithBody("endpointSuffix", "return '" + this.getEndpointSuffix() + "';"));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rows", layout.getRows());
        parameters.put("renderButtons", true);
        String output = this.renderTemplate(TASK_LAYOUT_TEMPLATE, parameters);
        parameters = new HashMap();
        parameters.put(HEADER_LAYOUT_TEMPLATE, form.getName());
        parameters.put("body", output);
        parameters.put("scriptData", this.buildScriptData(scriptDataList));
        parameters.put("serverPath", this.resourcePath);
        String finalOutput = this.renderTemplate(MAIN_LAYOUT_TEMPLATE, parameters);
        return finalOutput;
    }

    protected void processFormLayout(FormInstance topLevelForm, FormInstance form, Map<String, Object> inputs, Map<String, Object> outputs, String layoutTemplate, StringBuilder jsonTemplate, boolean wrapJson, List<String> scriptDataList) {
        FormLayout layout = form.getLayout();
        if (form.getModel().getClassName() != null && wrapJson) {
            Optional<FormField> fieldForm = topLevelForm.getFields().stream().filter(e -> e.getNestedForm() != null && e.getNestedForm().equals(form.getId())).findAny();
            jsonTemplate.append("'");
            if (fieldForm.isPresent()) {
                jsonTemplate.append(fieldForm.get().getBinding());
            } else {
                jsonTemplate.append(form.getModel().getName());
            }
            jsonTemplate.append("' : ").append("{").append("'").append(form.getModel().getClassName()).append("' : ").append("{");
        }
        for (LayoutRow row : layout.getRows()) {
            row.setHeader(form.getName());
            for (LayoutColumn column : row.getColumns()) {
                StringBuilder content = new StringBuilder();
                for (LayoutItem item : column.getItems()) {
                    if (item.getValue() != null) {
                        String output = (String)item.getValue();
                        if (output.contains("${")) {
                            String uuid = UUID.randomUUID().toString();
                            this.loadTemplate(this.fieldLevelStringLoader, uuid, new ByteArrayInputStream(output.getBytes(Charset.forName("UTF-8"))));
                            HashMap<String, Object> parameters = new HashMap<String, Object>();
                            parameters.putAll(inputs);
                            parameters.putAll(outputs);
                            output = this.renderTemplate(this.fieldLevelCfg, uuid, parameters);
                            this.fieldLevelStringLoader.removeTemplate(uuid);
                        }
                        content.append(output);
                        continue;
                    }
                    FormField field = form.getField(item.getFieldId());
                    if (field.getNestedForm() != null && !field.getNestedForm().isEmpty()) {
                        this.handleSubForm(topLevelForm, field, inputs, outputs, layoutTemplate, jsonTemplate, wrapJson, scriptDataList, content);
                        continue;
                    }
                    if (field.getCreationForm() != null) {
                        this.handleMultiSubForm(topLevelForm, field, inputs, outputs, layoutTemplate, jsonTemplate, scriptDataList, content);
                        continue;
                    }
                    String fieldType = this.inputTypes.get(field.getCode());
                    if (fieldType != null) {
                        String jsType = this.getFieldType(field.getType());
                        item.setId(field.getId());
                        item.setName(this.nonNull(field.getName()));
                        item.setLabel(this.nonNull(field.getLabel()));
                        item.setPlaceHolder(this.nonNull(field.getPlaceHolder()));
                        item.setType(fieldType);
                        item.setOptions(field.getOptions());
                        item.setPattern(this.getValidationPatternByType(field.getType()));
                        item.setMin(field.getMin());
                        item.setMax(field.getMax());
                        item.setPrecision(field.getPrecision());
                        item.setStep(field.getStep());
                        Object value = "";
                        if (inputs.get(field.getBinding()) != null) {
                            value = inputs.get(field.getBinding());
                        }
                        if (outputs.get(field.getBinding()) != null) {
                            value = outputs.get(field.getBinding());
                        }
                        switch (fieldType) {
                            case "documentCollection": {
                                if (value instanceof DocumentCollection) {
                                    DocumentCollection docCollection = (DocumentCollection)value;
                                    docCollection.getDocuments().stream().map(e -> (DocumentImpl)e).forEach(DocumentImpl::load);
                                    List items = docCollection.getDocuments().stream().map(e -> new DocumentItem(e.getName(), Base64.getEncoder().encodeToString(e.getContent()))).collect(Collectors.toList());
                                    item.setValue(items);
                                    break;
                                }
                                item.setValue(Collections.emptyList());
                                break;
                            }
                            case "multipleSelector": {
                                item.setOptions(field.getListOfValues().stream().map(ItemOption::new).collect(Collectors.toList()));
                                if (value instanceof String) {
                                    item.setValue(Collections.singletonList(value));
                                    break;
                                }
                                item.setValue(value);
                                break;
                            }
                            case "multipleInput": {
                                if (value instanceof String) {
                                    item.setValue(value);
                                    break;
                                }
                                if (value instanceof List) {
                                    item.setValue(String.join((CharSequence)",", (List)value));
                                    break;
                                }
                                item.setValue("");
                                break;
                            }
                            default: {
                                item.setValue(value != null ? value.toString() : "");
                            }
                        }
                        Set<String> tags = field.getTags();
                        if (tags != null) {
                            item.setRequired(tags.contains("required"));
                            item.setReadOnly(tags.contains("readonly"));
                        } else {
                            item.setRequired(field.isRequired());
                            item.setReadOnly(field.isReadOnly());
                        }
                        HashMap<String, Object> parameters = new HashMap<String, Object>();
                        parameters.put("item", item);
                        if (("file".equals(fieldType) || "documentCollection".equals(fieldType)) && !item.getValue().equals("{}")) {
                            parameters.put("documentPath", this.getDocumentPath());
                        } else if ("file".equals(fieldType) && item.getValue().equals("{}")) {
                            item.setValue("");
                        }
                        parameters.put("maxItems", field.getMaxLength());
                        String output = this.renderTemplate(FORM_GROUP_LAYOUT_TEMPLATE, parameters);
                        content.append(output);
                        this.appendFieldJSON(jsonTemplate, fieldType, field.getBinding(), field.getId(), jsType);
                        continue;
                    }
                    logger.warn("Field type {} is not supported, skipping it...", (Object)field.getCode());
                }
                column.setContent(content.toString());
            }
        }
        if (form.getModel().getClassName() != null && wrapJson) {
            jsonTemplate.deleteCharAt(jsonTemplate.length() - 1).append("}").append("}").append(",");
        }
    }

    protected void handleSubForm(FormInstance topLevelForm, FormField field, Map<String, Object> inputs, Map<String, Object> outputs, String layoutTemplate, StringBuilder jsonTemplate, boolean wrapJson, List<String> scriptDataList, StringBuilder content) {
        Map<String, Object> nestedDataExtracted;
        FormInstance nestedForm = topLevelForm.getNestedForm(field.getNestedForm());
        if (nestedForm == null) {
            throw new RuntimeException("Unable to find nested form with form id " + field.getNestedForm());
        }
        HashMap<String, Object> nestedInputs = new HashMap<String, Object>(inputs);
        HashMap<String, Object> nestedOutputs = new HashMap<String, Object>(outputs);
        Object binding = outputs.get(field.getBinding());
        if (binding == null) {
            binding = inputs.get(field.getBinding());
            nestedDataExtracted = this.reader.extractValues(binding);
            nestedInputs.putAll(nestedDataExtracted);
        } else {
            nestedDataExtracted = this.reader.extractValues(binding);
            nestedOutputs.putAll(nestedDataExtracted);
        }
        this.processFormLayout(topLevelForm, nestedForm, nestedInputs, nestedOutputs, layoutTemplate, jsonTemplate, wrapJson, scriptDataList);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(HEADER_LAYOUT_TEMPLATE, nestedForm.getName());
        String output = this.renderTemplate(HEADER_LAYOUT_TEMPLATE, parameters);
        content.append(output);
        FormLayout nestedLayout = nestedForm.getLayout();
        parameters = new HashMap();
        parameters.put("rows", nestedLayout.getRows());
        output = this.renderTemplate(layoutTemplate, parameters);
        content.append(output);
    }

    protected void handleMultiSubForm(FormInstance topLevelForm, FormField field, Map<String, Object> inputs, Map<String, Object> outputs, String layoutTemplate, StringBuilder jsonTemplate, List<String> scriptDataList, StringBuilder content) {
        FormInstance nestedForm = topLevelForm.getNestedForm(field.getCreationForm());
        if (nestedForm == null) {
            throw new RuntimeException("Unable to find creation form with form id " + field.getCreationForm());
        }
        for (TableInfo tableInfo : field.getTableInfo()) {
            FormField nestedField = nestedForm.getFieldByBinding(tableInfo.getProperty());
            String jsType = this.getFieldType(nestedField.getType());
            tableInfo.setType(jsType);
        }
        Object bindingData = outputs.get(field.getBinding());
        if (bindingData == null) {
            bindingData = inputs.get(field.getBinding());
        }
        if (bindingData != null && bindingData instanceof Collection) {
            LinkedHashMap mappedData = new LinkedHashMap();
            int index = 0;
            for (Object data : (Collection)bindingData) {
                mappedData.put("table_" + field.getId() + "_" + index, data);
                ++index;
            }
            String jsonData = this.reader.toJson(mappedData);
            String loadDataScript = "tableData.set('table_" + field.getId() + "', new Map(Object.entries(JSON.parse('" + jsonData + "'))));";
            scriptDataList.add(loadDataScript);
        }
        StringBuilder creationJsonTemplate = new StringBuilder("{");
        this.processFormLayout(topLevelForm, nestedForm, inputs, outputs, layoutTemplate, creationJsonTemplate, false, scriptDataList);
        creationJsonTemplate.deleteCharAt(creationJsonTemplate.length() - 1).append("}");
        scriptDataList.add(this.buildFunctionWithBody("formData_" + field.getId(), " return " + creationJsonTemplate.toString() + ";"));
        FormLayout nestedLayout = nestedForm.getLayout();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rows", nestedLayout.getRows());
        String output = this.renderTemplate(layoutTemplate, parameters);
        parameters = new HashMap();
        parameters.put("tableColumns", field.getTableInfo());
        parameters.put("tableData", bindingData);
        parameters.put("fieldId", field.getId());
        parameters.put("label", field.getLabel());
        parameters.put("type", field.getType());
        parameters.put("creationForm", output);
        output = this.renderTemplate(TABLE_LAYOUT_TEMPLATE, parameters);
        content.append(output);
        jsonTemplate.append("'").append(field.getBinding()).append("' : getTableData('table_").append(field.getId()).append("')").append(",");
    }

    protected abstract void loadTemplates();

    protected void loadTemplate(String templateId, InputStream stream) {
        this.loadTemplate(this.stringLoader, templateId, stream);
    }

    protected void loadTemplate(StringTemplateLoader loader, String templateId, InputStream stream) {
        try {
            loader.putTemplate(templateId, this.read(stream));
            logger.debug("Loaded template {} from input stream", (Object)templateId);
        }
        catch (Exception e) {
            logger.warn("Exception while loading template from input stream due to {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String read(InputStream input) {
        String lineSeparator = System.getProperty("line.separator");
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));){
            String string = buffer.lines().collect(Collectors.joining(lineSeparator));
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String renderTemplate(String templateName, Map<String, Object> parameters) {
        return this.renderTemplate(this.cfg, templateName, parameters);
    }

    protected String renderTemplate(Configuration cfg, String templateName, Map<String, Object> parameters) {
        StringWriter out = new StringWriter();
        try {
            Template template = cfg.getTemplate(templateName);
            template.process(parameters, (Writer)out);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Template " + templateName + " not found", e);
        }
        return out.toString();
    }

    protected void appendFieldJSON(StringBuilder jsonTemplate, String type, String name, String id, String jsType) {
        jsonTemplate.append("'").append(name).append("' : ").append(this.getFieldType(type)).append(this.appendExtractionExpression(type, name, id, jsType)).append(this.wrapEndFieldType(type)).append(",");
    }

    protected String getFieldType(String type) {
        if (type.contains("Integer") || type.contains("Double") || type.contains("Float")) {
            return "Number(";
        }
        if (type.contains("Boolean")) {
            return "Boolean(";
        }
        if (type.contains("Date")) {
            return "Object(";
        }
        if (type.contains("Document") || type.contains("documentCollection") || type.contains("multipleSelector") || type.contains("multipleInput")) {
            return "Object(";
        }
        if (type.contains("slider")) {
            return " { \"java.lang.Double\" : Number(";
        }
        return "String(";
    }

    protected String wrapEndFieldType(String type) {
        if (type.contains("slider")) {
            return ").toFixed(2) }";
        }
        return ")";
    }

    protected String appendExtractionExpression(String type, String name, String id, String jsType) {
        StringBuilder jsonTemplate = new StringBuilder();
        if (type.equals("radio")) {
            jsonTemplate.append("$('input[name=").append(name).append("]:checked').val()");
        } else if (type.equals("select")) {
            jsonTemplate.append("$('#").append(id).append("').val()");
        } else if (type.equals("file")) {
            jsonTemplate.append("getDocumentData('").append(id).append("')");
        } else if (type.equals("date")) {
            jsonTemplate.append("getDateFormated('").append(id).append("')");
        } else if (type.equals("documentCollection")) {
            jsonTemplate.append("getDocumentCollectionData('").append(id).append("')");
        } else if (type.equals("multipleSelector")) {
            jsonTemplate.append("getMultipleSelectorData('").append(id).append("')");
        } else if (type.equals("multipleInput")) {
            jsonTemplate.append("getMultipleInputData('").append(id).append("')");
        } else {
            jsonTemplate.append("document.getElementById('").append(id).append("')").append(this.getExtractionValue(jsType));
        }
        return jsonTemplate.toString();
    }

    protected void appendRoleAssignment(CaseDefinition caseDefinition, StringBuilder jsonTemplate) {
        jsonTemplate.append("'case-user-assignments' : {");
        for (CaseRole role : caseDefinition.getCaseRoles()) {
            this.appendFieldJSON(jsonTemplate, "text", role.getName(), "user_" + role.getName(), "String(");
        }
        jsonTemplate.deleteCharAt(jsonTemplate.length() - 1).append("}, ");
        jsonTemplate.append("'case-group-assignments' : {");
        for (CaseRole role : caseDefinition.getCaseRoles()) {
            this.appendFieldJSON(jsonTemplate, "text", role.getName(), "group_" + role.getName(), "String(");
        }
        jsonTemplate.deleteCharAt(jsonTemplate.length() - 1).append("}, ");
    }

    protected String buildFunctionWithBody(String name, String body) {
        StringBuilder function = new StringBuilder();
        return function.append("function ").append(name).append("() { \n").append(body).append("\n };").toString();
    }

    protected String buildScriptData(List<String> scriptDataList) {
        StringBuilder scripts = new StringBuilder();
        for (String script : scriptDataList) {
            scripts.append(script).append("\n");
        }
        return scripts.toString();
    }

    protected String getExtractionValue(String jsType) {
        if (jsType.equals("Boolean(")) {
            return ".checked";
        }
        return ".value";
    }

    protected String getValidationPatternByType(String type) {
        if (type.contains("Integer")) {
            return "^\\d+$";
        }
        if (type.contains("Double") || type.contains("Float")) {
            return "^\\d+(\\.\\d+)?$";
        }
        if (type.contains("Date")) {
            return "(\\d+)(-|\\/)(\\d+)(?:-|\\/)(?:(\\d+)\\s+(\\d+):(\\d+)(?::(\\d+))?(?:\\.(\\d+))?)?";
        }
        return "";
    }

    protected String nonNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    protected String getServerEndpointPath() {
        return this.serverPath;
    }

    protected String getEndpointSuffix() {
        return "";
    }

    protected String getDocumentPath() {
        return this.serverPath + "/documents/DOC_ID/content";
    }

    public static class DocumentItem {
        String name;
        String content;

        DocumentItem(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public String getContent() {
            return this.content;
        }
    }
}

