/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.jbpm.ui.ImageServiceBase;
import org.kie.server.services.jbpm.ui.img.ImageReference;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RunWith(value=MockitoJUnitRunner.class)
public class ImageServiceBaseTest {
    @Mock
    KieServerRegistry kieServerRegistry = new KieServerRegistryImpl();
    @Mock
    RuntimeDataService dataService;
    @Mock
    ImageReference imageReference;
    @Mock
    KieServerConfig config;

    @Test
    public void testHighValueSubProcessInstanceId() {
        ImageServiceBase imageServiceBase = new ImageServiceBase();
        org.jbpm.kie.services.impl.model.NodeInstanceDesc node = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("9999", "1234", "Test node", "SubProcessNode", "test-deployment", 1001L, new Date(), "test-connection", 1, Long.valueOf(2001L), Long.valueOf(3001L), "", null, null);
        HashMap subProcessLinks = new HashMap();
        imageServiceBase.populateSubProcessLink("test", (NodeInstanceDesc)node, subProcessLinks);
        Assert.assertEquals((long)1L, (long)subProcessLinks.size());
        Assert.assertEquals((Object)"containers/test/images/processes/instances/3001", subProcessLinks.get("1234"));
    }

    @Test
    public void testIncludedViewBoxAtProcessImage() throws Exception {
        String containerId = "test-container";
        String processId = "test-processId";
        byte[] byteArray = this.getInputStreamAsByteArray(ImageServiceBaseTest.class.getResourceAsStream("/evaluation-svg.svg"));
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId)).thenReturn((Object)((ProcessDefinition)Mockito.mock(ProcessDefinition.class)));
        Mockito.when((Object)this.imageReference.getImageContent(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)byteArray);
        Mockito.when((Object)this.kieServerRegistry.getContainerId(Matchers.anyString(), (ContainerLocator)Matchers.any(ContainerLocator.class))).thenReturn((Object)containerId);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getConfigItemValue(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"");
        HashMap<String, ImageReference> imageReferenceMap = new HashMap<String, ImageReference>();
        imageReferenceMap.put(containerId, this.imageReference);
        ImageServiceBase imageServiceBase = new ImageServiceBase(this.dataService, imageReferenceMap, this.kieServerRegistry);
        String processImageStr = imageServiceBase.getProcessImage(containerId, "test-processId");
        Document svgDocument = this.readSVG(processImageStr);
        Assert.assertEquals((Object)"", (Object)((Element)svgDocument.getFirstChild()).getAttribute("width"));
        Assert.assertEquals((Object)"", (Object)((Element)svgDocument.getFirstChild()).getAttribute("height"));
        Assert.assertEquals((Object)"0 0 3000 2000", (Object)svgDocument.getFirstChild().getAttributes().getNamedItem("viewBox").getNodeValue());
    }

    private byte[] getInputStreamAsByteArray(InputStream inputStream) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Document readSVG(String svgContent) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        factory.setValidating(false);
        Document svgDocument = factory.createDocument("http://jbpm.org", (Reader)new StringReader(svgContent));
        return svgDocument;
    }

    @Test
    public void testLoopSubProcess() throws Exception {
        String containerId = "test-container";
        String processId = "test-processId";
        long processInstanceId = 10L;
        byte[] byteArray = this.getInputStreamAsByteArray(ImageServiceBaseTest.class.getResourceAsStream("/reusable-loop-svg-test-svg.svg"));
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId)).thenReturn((Object)((ProcessDefinition)Mockito.mock(ProcessDefinition.class)));
        Mockito.when((Object)this.imageReference.getImageContent(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)byteArray);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getConfigItemValue(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"");
        String nodeId = "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D";
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescCompleted1 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("1", "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D", "", "SubProcessNode", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(3L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescCompleted2 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("2", "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D", "", "", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(1L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescActive1 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("3", "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D", "", "SubProcessNode", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(4L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescActive2 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("4", "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D", "", "", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(1L), "", null, Integer.valueOf(1));
        List<NodeInstanceDesc> activeNodes = Arrays.asList(nodeInstanceDescActive1, nodeInstanceDescActive2);
        List<NodeInstanceDesc> completedNodes = Arrays.asList(nodeInstanceDescCompleted1, nodeInstanceDescCompleted2);
        List<NodeInstanceDesc> fullLogs = Arrays.asList(nodeInstanceDescCompleted1, nodeInstanceDescCompleted2, nodeInstanceDescActive1, nodeInstanceDescActive2);
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryCompleted(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(completedNodes);
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryActive(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(activeNodes);
        Mockito.when((Object)this.dataService.getProcessInstanceFullHistory(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(fullLogs);
        HashMap<String, ImageReference> imageReferenceMap = new HashMap<String, ImageReference>();
        imageReferenceMap.put(containerId, this.imageReference);
        ProcessInstanceDesc processInstanceDesc = new ProcessInstanceDesc(processInstanceId, processId, "", "", 1, containerId, null, "", "", "");
        Mockito.when((Object)this.dataService.getProcessInstanceById(processInstanceId)).thenReturn((Object)processInstanceDesc);
        ImageServiceBase imageServiceBase = new ImageServiceBase(this.dataService, imageReferenceMap, this.kieServerRegistry);
        String processImageStr = imageServiceBase.getActiveProcessImage(containerId, processInstanceId);
        Document svgDocument = this.readSVG(processImageStr);
        Element subprocessPlusIcon = svgDocument.getElementById("_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D_subProcessReusableNormalReusableIcon");
        String onclick = subprocessPlusIcon.getAttribute("onclick");
        Assert.assertNotNull((Object)onclick);
        Assert.assertEquals((Object)"window.open('/containers/test-container/images/processes/instances/4')", (Object)onclick);
        String style = subprocessPlusIcon.getAttribute("style");
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"cursor: pointer;", (Object)style);
    }

    @Test
    public void testSignalEventSubProcess() throws Exception {
        String containerId = "test-container";
        String processId = "test-processId";
        long processInstanceId = 10L;
        byte[] byteArray = this.getInputStreamAsByteArray(ImageServiceBaseTest.class.getResourceAsStream("/signal-event-subprocess-svg.svg"));
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId)).thenReturn((Object)((ProcessDefinition)Mockito.mock(ProcessDefinition.class)));
        Mockito.when((Object)this.imageReference.getImageContent(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)byteArray);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getConfigItemValue(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"");
        String abortNodeId = "_66CB2BD8-424B-4057-B672-F17B6D6F2AB4";
        String completedNodeId = "_9ACAA96A-93EC-4D51-8CF0-EAB1F28F5F56";
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescCompleted1 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("1", "_9ACAA96A-93EC-4D51-8CF0-EAB1F28F5F56", "", "StartNode", "", 1L, null, "", 1, Long.valueOf(1L), Long.valueOf(3L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescAbort = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("2", "_66CB2BD8-424B-4057-B672-F17B6D6F2AB4", "", "SubProcessNode", "", 1L, null, "", 2, Long.valueOf(1L), Long.valueOf(3L), "", null, Integer.valueOf(1));
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryCompleted(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(Arrays.asList(nodeInstanceDescCompleted1));
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryActive(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn((Object)Collections.EMPTY_LIST);
        List<NodeInstanceDesc> fullLogs = Arrays.asList(nodeInstanceDescAbort, nodeInstanceDescCompleted1);
        Mockito.when((Object)this.dataService.getProcessInstanceFullHistory(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(fullLogs);
        HashMap<String, ImageReference> imageReferenceMap = new HashMap<String, ImageReference>();
        imageReferenceMap.put(containerId, this.imageReference);
        ProcessInstanceDesc processInstanceDesc = new ProcessInstanceDesc(processInstanceId, processId, "", "", 1, containerId, null, "", "", "");
        Mockito.when((Object)this.dataService.getProcessInstanceById(processInstanceId)).thenReturn((Object)processInstanceDesc);
        ImageServiceBase imageServiceBase = new ImageServiceBase(this.dataService, imageReferenceMap, this.kieServerRegistry);
        String processImageStr = imageServiceBase.getActiveProcessImage(containerId, processInstanceId);
        Document svgDocument = this.readSVG(processImageStr);
        Element subprocessPlusIcon = svgDocument.getElementById("_66CB2BD8-424B-4057-B672-F17B6D6F2AB4_subProcessReusableNormalReusableIcon");
        String onclick = subprocessPlusIcon.getAttribute("onclick");
        Assert.assertNotNull((Object)onclick);
        Assert.assertEquals((Object)"window.open('/containers/test-container/images/processes/instances/3')", (Object)onclick);
        String style = subprocessPlusIcon.getAttribute("style");
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"cursor: pointer;", (Object)style);
    }
}

