/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.form;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.FormManagerServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.services.jbpm.ui.form.PurchaseOrder;
import org.kie.server.services.jbpm.ui.form.PurchaseOrderHeader;
import org.kie.server.services.jbpm.ui.form.PurchaseOrderLine;
import org.kie.server.services.jbpm.ui.form.RemoteFormModellerFormProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormFilterTest {
    public static final int EXPECTED_FORMS = 3;
    public static final int PURCHASE_ORDER_FIELDS = 5;
    private FormManagerService formManagerService;
    private RemoteFormModellerFormProvider formProvider;
    private String createOrderFormContent;
    private String headerFormContent;
    private String orderLineFormContent;

    @Before
    public void setup() throws IOException {
        this.formManagerService = new FormManagerServiceImpl();
        this.createOrderFormContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test-forms/CreateOrder.form"), (String)"UTF-8");
        this.headerFormContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test-forms/PurchaseHeader.form"), (String)"UTF-8");
        this.orderLineFormContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test-forms/PurchaseLine.form"), (String)"UTF-8");
        this.formManagerService.registerForm("test", "CreateOrder.form", this.createOrderFormContent);
        this.formManagerService.registerForm("test", "PurchaseHeader.form", this.headerFormContent);
        this.formManagerService.registerForm("test", "PurchaseLine.form", this.orderLineFormContent);
        this.formProvider = new RemoteFormModellerFormProvider();
        this.formProvider.configure(this.formManagerService);
    }

    @Test
    public void testFilterSubForm() throws Exception {
        HashMap<String, PurchaseOrder> inputs = new HashMap<String, PurchaseOrder>();
        PurchaseOrder purchaseOrder = new PurchaseOrder();
        purchaseOrder.setDescription("test description");
        purchaseOrder.setRequiresCFOApproval(true);
        purchaseOrder.setTotal(100.0);
        PurchaseOrderHeader header = new PurchaseOrderHeader();
        header.setCreationDate(new Date());
        header.setCustomer("john");
        header.setProject("test project");
        purchaseOrder.setHeader(header);
        ArrayList<PurchaseOrderLine> orderLines = new ArrayList<PurchaseOrderLine>();
        PurchaseOrderLine orderLine1 = new PurchaseOrderLine();
        orderLine1.setDescription("first line");
        orderLine1.setTotal(10.0);
        orderLine1.setAmount(2.0);
        orderLine1.setUnitPrice(25.0);
        orderLines.add(orderLine1);
        PurchaseOrderLine orderLine2 = new PurchaseOrderLine();
        orderLine2.setDescription("second line");
        orderLine2.setTotal(20.0);
        orderLine2.setAmount(4.0);
        orderLine2.setUnitPrice(25.0);
        orderLines.add(orderLine2);
        purchaseOrder.setLines(orderLines);
        inputs.put("po_in", purchaseOrder);
        HashMap<String, PurchaseOrder> outputs = new HashMap<String, PurchaseOrder>();
        PurchaseOrder purchaseOrderOut = new PurchaseOrder();
        purchaseOrderOut.setDescription("output description");
        purchaseOrderOut.setRequiresCFOApproval(true);
        purchaseOrderOut.setTotal(100.0);
        PurchaseOrderHeader headerOut = new PurchaseOrderHeader();
        headerOut.setCreationDate(new Date());
        headerOut.setCustomer("john output");
        headerOut.setProject("output project");
        purchaseOrderOut.setHeader(headerOut);
        ArrayList<PurchaseOrderLine> orderLinesOut = new ArrayList<PurchaseOrderLine>();
        PurchaseOrderLine orderLineOut = new PurchaseOrderLine();
        orderLineOut.setDescription("output line");
        orderLineOut.setTotal(10.0);
        orderLineOut.setAmount(2.0);
        orderLineOut.setUnitPrice(25.0);
        orderLinesOut.add(orderLineOut);
        purchaseOrderOut.setLines(orderLinesOut);
        outputs.put("po_out", purchaseOrderOut);
        String filteredForm = this.formProvider.filterXML(this.createOrderFormContent, "en", "test", inputs, outputs);
        this.validateFormXML(filteredForm);
    }

    @Test
    public void testAddSubForm() throws Exception {
        String allForms = this.formProvider.attachSubForms(this.createOrderFormContent, "test");
        this.validateFormXML(allForms);
    }

    private void validateFormXML(String formXML) throws Exception {
        Assert.assertNotNull((Object)formXML);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(formXML.getBytes()));
        Assert.assertNotNull((Object)doc);
        NodeList allForms = doc.getElementsByTagName("form");
        Assert.assertEquals((long)3L, (long)allForms.getLength());
        Node nodeForm = allForms.item(0);
        NodeList childNodes = nodeForm.getChildNodes();
        int childCount = 0;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!node.getNodeName().equals("field")) continue;
            ++childCount;
        }
        Assert.assertEquals((long)5L, (long)childCount);
    }
}

