/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.jbpm.ui.ImageServiceBase;
import org.kie.server.services.jbpm.ui.img.ImageReference;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RunWith(value=MockitoJUnitRunner.class)
public class ImageServiceBaseTest {
    @Mock
    KieServerRegistry kieServerRegistry = new KieServerRegistryImpl();
    @Mock
    RuntimeDataService dataService;
    @Mock
    ImageReference imageReference;
    @Mock
    KieServerConfig config;

    @Test
    public void testHighValueSubProcessInstanceId() {
        ImageServiceBase imageServiceBase = new ImageServiceBase();
        org.jbpm.kie.services.impl.model.NodeInstanceDesc node = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("9999", "1234", "Test node", "SubProcessNode", "test-deployment", 1001L, new Date(), "test-connection", 1, Long.valueOf(2001L), Long.valueOf(3001L), "", null, null);
        HashMap subProcessLinks = new HashMap();
        imageServiceBase.populateSubProcessLink("test", (NodeInstanceDesc)node, subProcessLinks);
        Assert.assertEquals((long)1L, (long)subProcessLinks.size());
        Assert.assertEquals((Object)"containers/test/images/processes/instances/3001", subProcessLinks.get("1234"));
    }

    @Test
    public void testIncludedViewBoxAtProcessImage() throws Exception {
        String containerId = "test-container";
        String processId = "test-processId";
        byte[] byteArray = this.getInputStreamAsByteArray(ImageServiceBaseTest.class.getResourceAsStream("/evaluation-svg.svg"));
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId)).thenReturn((Object)((ProcessDefinition)Mockito.mock(ProcessDefinition.class)));
        Mockito.when((Object)this.imageReference.getImageContent(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)byteArray);
        Mockito.when((Object)this.kieServerRegistry.getContainerId(Matchers.anyString(), (ContainerLocator)Matchers.any(ContainerLocator.class))).thenReturn((Object)containerId);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getConfigItemValue(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"");
        HashMap<String, ImageReference> imageReferenceMap = new HashMap<String, ImageReference>();
        imageReferenceMap.put(containerId, this.imageReference);
        ImageServiceBase imageServiceBase = new ImageServiceBase(this.dataService, imageReferenceMap, this.kieServerRegistry);
        String processImageStr = imageServiceBase.getProcessImage(containerId, "test-processId");
        Document svgDocument = this.readSVG(processImageStr);
        Assert.assertEquals((Object)"", (Object)((Element)svgDocument.getFirstChild()).getAttribute("width"));
        Assert.assertEquals((Object)"", (Object)((Element)svgDocument.getFirstChild()).getAttribute("height"));
        Assert.assertEquals((Object)"0 0 3000 2000", (Object)svgDocument.getFirstChild().getAttributes().getNamedItem("viewBox").getNodeValue());
    }

    private byte[] getInputStreamAsByteArray(InputStream inputStream) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Document readSVG(String svgContent) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        factory.setValidating(false);
        Document svgDocument = factory.createDocument("http://jbpm.org", (Reader)new StringReader(svgContent));
        return svgDocument;
    }

    @Test
    public void testLoopSubProcess() throws Exception {
        String containerId = "test-container";
        String processId = "test-processId";
        long processInstanceId = 10L;
        byte[] byteArray = this.getInputStreamAsByteArray(ImageServiceBaseTest.class.getResourceAsStream("/reusable-loop-svg-test-svg.svg"));
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId)).thenReturn((Object)((ProcessDefinition)Mockito.mock(ProcessDefinition.class)));
        Mockito.when((Object)this.imageReference.getImageContent(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)byteArray);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getConfigItemValue(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"");
        String nodeId = "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D";
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescCompleted1 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("1", "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D", "", "SubProcessNode", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(3L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescCompleted2 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("2", "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D", "", "", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(1L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescActive1 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("3", "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D", "", "SubProcessNode", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(4L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescActive2 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("4", "_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D", "", "", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(1L), "", null, Integer.valueOf(1));
        List<NodeInstanceDesc> activeNodes = Arrays.asList(nodeInstanceDescActive1, nodeInstanceDescActive2);
        List<NodeInstanceDesc> finishedNodes = Arrays.asList(nodeInstanceDescCompleted1, nodeInstanceDescCompleted2);
        List<NodeInstanceDesc> fullLogs = Arrays.asList(nodeInstanceDescCompleted1, nodeInstanceDescCompleted2, nodeInstanceDescActive1, nodeInstanceDescActive2);
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryFinished(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(finishedNodes);
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryActive(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(activeNodes);
        Mockito.when((Object)this.dataService.getProcessInstanceFullHistory(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(fullLogs);
        HashMap<String, ImageReference> imageReferenceMap = new HashMap<String, ImageReference>();
        imageReferenceMap.put(containerId, this.imageReference);
        ProcessInstanceDesc processInstanceDesc = new ProcessInstanceDesc(processInstanceId, processId, "", "", 1, containerId, null, "", "", "");
        Mockito.when((Object)this.dataService.getProcessInstanceById(processInstanceId)).thenReturn((Object)processInstanceDesc);
        ImageServiceBase imageServiceBase = new ImageServiceBase(this.dataService, imageReferenceMap, this.kieServerRegistry);
        String processImageStr = imageServiceBase.getActiveProcessImage(containerId, processInstanceId);
        Document svgDocument = this.readSVG(processImageStr);
        Element subprocessPlusIcon = svgDocument.getElementById("_D2EEB1C1-4C06-4FDC-A0CA-73DFDA3A068D_subProcessReusableNormalReusableIcon");
        String onclick = subprocessPlusIcon.getAttribute("onclick");
        Assert.assertNotNull((Object)onclick);
        Assert.assertEquals((Object)"window.open('/containers/test-container/images/processes/instances/4')", (Object)onclick);
        String style = subprocessPlusIcon.getAttribute("style");
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"cursor: pointer;", (Object)style);
    }

    @Test
    public void testSvgNodesBorderColoring() throws Exception {
        String containerId = "test-container";
        String processId = "test-processId";
        long processInstanceId = 10L;
        String humanTaskOne = "_C8E8A0C7-ECC6-4C28-B1FE-D6DE5999239E";
        String oneScriptNode = "_BA99E908-87C6-46C9-99ED-901DFCD1A2AA";
        String twoScriptNode = "_1C98770B-2C62-41F1-AFBF-7B138EE5270E";
        String threeScriptNode = "_D7C7D018-DC2D-4B97-BEFF-55B50F201103";
        byte[] byteArray = this.getInputStreamAsByteArray(ImageServiceBaseTest.class.getResourceAsStream("/testProcess.svg"));
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId)).thenReturn((Object)((ProcessDefinition)Mockito.mock(ProcessDefinition.class)));
        Mockito.when((Object)this.imageReference.getImageContent(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)byteArray);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getConfigItemValue(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"");
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescActive = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("1", humanTaskOne, "", "HumanTask", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(3L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescCompleted1 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("2", oneScriptNode, "", "ScriptNode", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(1L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescCompleted2 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("3", twoScriptNode, "", "ScriptNode", "", 1L, null, "", 0, Long.valueOf(1L), Long.valueOf(4L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescError = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("4", threeScriptNode, "", "ScriptNode", "", 1L, null, "", 6, Long.valueOf(1L), Long.valueOf(1L), "", null, Integer.valueOf(1));
        List<NodeInstanceDesc> activeNodes = Arrays.asList(nodeInstanceDescActive);
        List<NodeInstanceDesc> finishedNodes = Arrays.asList(nodeInstanceDescCompleted1, nodeInstanceDescCompleted2);
        List<NodeInstanceDesc> fullLogs = Arrays.asList(nodeInstanceDescActive, nodeInstanceDescCompleted1, nodeInstanceDescCompleted2, nodeInstanceDescError);
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryFinished(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(finishedNodes);
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryActive(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(activeNodes);
        Mockito.when((Object)this.dataService.getProcessInstanceFullHistory(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(fullLogs);
        HashMap<String, ImageReference> imageReferenceMap = new HashMap<String, ImageReference>();
        imageReferenceMap.put(containerId, this.imageReference);
        ProcessInstanceDesc processInstanceDesc = new ProcessInstanceDesc(processInstanceId, processId, "", "", 1, containerId, null, "", "", "");
        Mockito.when((Object)this.dataService.getProcessInstanceById(processInstanceId)).thenReturn((Object)processInstanceDesc);
        ImageServiceBase imageServiceBase = new ImageServiceBase(this.dataService, imageReferenceMap, this.kieServerRegistry);
        String processImageStr = imageServiceBase.getActiveProcessImage(containerId, processInstanceId);
        Document svgDocument = this.readSVG(processImageStr);
        this.checkStrokeAttributeAtNode(svgDocument, humanTaskOne, "#1e90ff");
        this.checkStrokeAttributeAtNode(svgDocument, oneScriptNode, "#030303");
        this.checkStrokeAttributeAtNode(svgDocument, twoScriptNode, "#030303");
        this.checkStrokeAttributeAtNode(svgDocument, threeScriptNode, "#FF0000");
        String completedNodeColor = "black";
        String completedNodeBorderColor = "grey";
        String activeNodeBorderColor = "blue";
        String activeAsyncNodeBorderColor = "red";
        processImageStr = imageServiceBase.getActiveProcessImage(containerId, processInstanceId, completedNodeColor, completedNodeBorderColor, activeNodeBorderColor, Boolean.valueOf(false), activeAsyncNodeBorderColor);
        svgDocument = this.readSVG(processImageStr);
        this.checkStrokeAttributeAtNode(svgDocument, humanTaskOne, activeNodeBorderColor);
        this.checkStrokeAttributeAtNode(svgDocument, oneScriptNode, completedNodeBorderColor);
        this.checkStrokeAttributeAtNode(svgDocument, twoScriptNode, completedNodeBorderColor);
        this.checkStrokeAttributeAtNode(svgDocument, threeScriptNode, activeAsyncNodeBorderColor);
    }

    @Test
    public void testSignalEventSubProcess() throws Exception {
        String containerId = "test-container";
        String processId = "test-processId";
        long processInstanceId = 10L;
        byte[] byteArray = this.getInputStreamAsByteArray(ImageServiceBaseTest.class.getResourceAsStream("/signal-event-subprocess-svg.svg"));
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId)).thenReturn((Object)((ProcessDefinition)Mockito.mock(ProcessDefinition.class)));
        Mockito.when((Object)this.imageReference.getImageContent(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)byteArray);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getConfigItemValue(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"");
        String abortNodeId = "_66CB2BD8-424B-4057-B672-F17B6D6F2AB4";
        String completedNodeId = "_9ACAA96A-93EC-4D51-8CF0-EAB1F28F5F56";
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescCompleted1 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("1", "_9ACAA96A-93EC-4D51-8CF0-EAB1F28F5F56", "", "StartNode", "", 1L, null, "", 1, Long.valueOf(1L), Long.valueOf(3L), "", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstanceDescAbort = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("2", "_66CB2BD8-424B-4057-B672-F17B6D6F2AB4", "", "SubProcessNode", "", 1L, null, "", 2, Long.valueOf(1L), Long.valueOf(3L), "", null, Integer.valueOf(1));
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryFinished(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(Arrays.asList(nodeInstanceDescCompleted1));
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryActive(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn((Object)Collections.EMPTY_LIST);
        List<NodeInstanceDesc> fullLogs = Arrays.asList(nodeInstanceDescAbort, nodeInstanceDescCompleted1);
        Mockito.when((Object)this.dataService.getProcessInstanceFullHistory(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(fullLogs);
        HashMap<String, ImageReference> imageReferenceMap = new HashMap<String, ImageReference>();
        imageReferenceMap.put(containerId, this.imageReference);
        ProcessInstanceDesc processInstanceDesc = new ProcessInstanceDesc(processInstanceId, processId, "", "", 1, containerId, null, "", "", "");
        Mockito.when((Object)this.dataService.getProcessInstanceById(processInstanceId)).thenReturn((Object)processInstanceDesc);
        ImageServiceBase imageServiceBase = new ImageServiceBase(this.dataService, imageReferenceMap, this.kieServerRegistry);
        String processImageStr = imageServiceBase.getActiveProcessImage(containerId, processInstanceId);
        Document svgDocument = this.readSVG(processImageStr);
        Element subprocessPlusIcon = svgDocument.getElementById("_66CB2BD8-424B-4057-B672-F17B6D6F2AB4_subProcessReusableNormalReusableIcon");
        String onclick = subprocessPlusIcon.getAttribute("onclick");
        Assert.assertNotNull((Object)onclick);
        Assert.assertEquals((Object)"window.open('/containers/test-container/images/processes/instances/3')", (Object)onclick);
        String style = subprocessPlusIcon.getAttribute("style");
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"cursor: pointer;", (Object)style);
    }

    @Test
    public void testSvgAsyncNodesBorderColoring() throws Exception {
        String containerId = "test-container";
        String processId = "test-processId";
        long processInstanceId = 10L;
        String node_start = "_ED165B85-E65D-42A6-B0EF-8A160356271E";
        String node_self_evaluation = "_D3E17247-1D94-47D8-93AD-D645E317B736";
        String node_asyncOk = "_9C7235D4-C26C-4EB8-9724-9AAC5C02CCE5";
        String node_split = "_930D6071-9D06-42C3-946F-BA46C09EF157";
        String node_hr_evaluation = "_AB431E82-86BC-460F-9D8B-7A7617565B36";
        String node_pm_evaluation = "_E35438DF-03AF-4D7B-9DCB-30BC70E7E92E";
        String node_async_failing = "_502513E3-41BD-40AC-8C41-F32566D9FA2B";
        byte[] byteArray = this.getInputStreamAsByteArray(ImageServiceBaseTest.class.getResourceAsStream("/evaluation_async.svg"));
        Mockito.when((Object)this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId)).thenReturn((Object)((ProcessDefinition)Mockito.mock(ProcessDefinition.class)));
        Mockito.when((Object)this.imageReference.getImageContent(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)byteArray);
        Mockito.when((Object)this.kieServerRegistry.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getConfigItemValue(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)"");
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance8_2 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("8", node_async_failing, "", "AsyncEventNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 6, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance8 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("8", node_async_failing, "", "AsyncEventNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 6, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance6_end = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("6", node_pm_evaluation, "PM_evaluation", "HumanTaskNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 1, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance6_start = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("6", node_pm_evaluation, "PM_evaluation", "HumanTaskNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 0, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance5_end = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("5", node_split, "", "Split", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 1, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance7_start = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("7", node_hr_evaluation, "HR Evaluation", "HumanTaskNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 0, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance5_start = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("5", node_split, "", "Split", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 0, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance5_end2 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("5", node_split, "", "Split", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 1, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance3_end = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("3", node_asyncOk, "AsyncOK", "ActionNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 1, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance3_start = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("3", node_asyncOk, "AsyncOK", "ActionNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 0, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance2 = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("2", node_asyncOk, "", "AsyncEventNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 6, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance1_end = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("1", node_self_evaluation, "Self Evaluation", "HumanTaskNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 1, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance1_start = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("1", node_self_evaluation, "Self Evaluation", "HumanTaskNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 0, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance0_end = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("0", node_start, "", "StartNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 1, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        org.jbpm.kie.services.impl.model.NodeInstanceDesc nodeInstance0_start = new org.jbpm.kie.services.impl.model.NodeInstanceDesc("0", node_start, "", "StartNode", "evaluation_1.0.0-SNAPSHOT", processInstanceId, null, "", 0, null, null, "evaluation_1.0.0-SNAPSHOT", null, Integer.valueOf(1));
        List<NodeInstanceDesc> activeNodes = Arrays.asList(nodeInstance7_start);
        List<NodeInstanceDesc> finishedNodes = Arrays.asList(nodeInstance0_end, nodeInstance1_end, nodeInstance3_end, nodeInstance5_end, nodeInstance5_end2, nodeInstance6_end);
        List<NodeInstanceDesc> fullLogs = Arrays.asList(nodeInstance0_end, nodeInstance0_start, nodeInstance1_start, nodeInstance1_end, nodeInstance2, nodeInstance3_end, nodeInstance3_start, nodeInstance5_end, nodeInstance5_end2, nodeInstance5_start, nodeInstance6_end, nodeInstance6_start, nodeInstance7_start, nodeInstance8, nodeInstance8_2);
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryFinished(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(finishedNodes);
        Mockito.when((Object)this.dataService.getProcessInstanceHistoryActive(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(activeNodes);
        Mockito.when((Object)this.dataService.getProcessInstanceFullHistory(ArgumentMatchers.anyLong(), (QueryContext)Matchers.any())).thenReturn(fullLogs);
        HashMap<String, ImageReference> imageReferenceMap = new HashMap<String, ImageReference>();
        imageReferenceMap.put(containerId, this.imageReference);
        ProcessInstanceDesc processInstanceDesc = new ProcessInstanceDesc(processInstanceId, processId, "", "", 1, containerId, null, "", "", "");
        Mockito.when((Object)this.dataService.getProcessInstanceById(processInstanceId)).thenReturn((Object)processInstanceDesc);
        ImageServiceBase imageServiceBase = new ImageServiceBase(this.dataService, imageReferenceMap, this.kieServerRegistry);
        String processImageStr = imageServiceBase.getActiveProcessImage(containerId, processInstanceId);
        Document svgDocument = this.readSVG(processImageStr);
        this.checkStrokeAttributeAtNode(svgDocument, node_hr_evaluation, "#1e90ff");
        this.checkStrokeAttributeAtNode(svgDocument, node_self_evaluation, "#030303");
        this.checkStrokeAttributeAtNode(svgDocument, node_pm_evaluation, "#030303");
        this.checkStrokeAttributeAtNode(svgDocument, node_async_failing, "#FF0000");
        this.checkStrokeAttributeAtNode(svgDocument, node_asyncOk, "#030303");
        String completedNodeColor = "black";
        String completedNodeBorderColor = "grey";
        String activeNodeBorderColor = "blue";
        String activeAsyncNodeBorderColor = "red";
        processImageStr = imageServiceBase.getActiveProcessImage(containerId, processInstanceId, completedNodeColor, completedNodeBorderColor, activeNodeBorderColor, Boolean.valueOf(false), activeAsyncNodeBorderColor);
        svgDocument = this.readSVG(processImageStr);
        this.checkStrokeAttributeAtNode(svgDocument, node_hr_evaluation, activeNodeBorderColor);
        this.checkStrokeAttributeAtNode(svgDocument, node_self_evaluation, completedNodeBorderColor);
        this.checkStrokeAttributeAtNode(svgDocument, node_pm_evaluation, completedNodeBorderColor);
        this.checkStrokeAttributeAtNode(svgDocument, node_asyncOk, completedNodeBorderColor);
        this.checkStrokeAttributeAtNode(svgDocument, node_async_failing, activeAsyncNodeBorderColor);
    }

    private void checkStrokeAttributeAtNode(Document svgDocument, String nodeId, String expectedStrokeValue) {
        Element humanTaskBorderElement = svgDocument.getElementById(nodeId + "?shapeType=BORDER&renderType=STROKE");
        String stroke = humanTaskBorderElement.getAttribute("stroke");
        Assert.assertNotNull((Object)stroke);
        Assert.assertEquals((Object)expectedStrokeValue, (Object)stroke);
    }
}

