/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.form.render;

import org.assertj.core.api.Assertions;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.junit.Test;
import org.kie.server.services.jbpm.ui.form.render.BootstrapFormRenderer;
import org.kie.server.services.jbpm.ui.form.render.FormReader;
import org.kie.server.services.jbpm.ui.form.render.model.FormInstance;

public class BootstrapFormRendererTest {
    @Test
    public void testProcessFormRendererWithDate() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/date-form.json"));
        ProcessAssetDesc processAssetDesc = new ProcessAssetDesc();
        processAssetDesc.setId("test-id");
        BootstrapFormRenderer bootstrapFormRenderer = new BootstrapFormRenderer();
        String outString = bootstrapFormRenderer.renderProcess("test-containerId", (ProcessDefinition)processAssetDesc, form);
        Assertions.assertThat((String)outString).contains(new CharSequence[]{"'dateBirth' : getDateWithoutTime('field_1703386699666296E12',getFormattedLocalDateTime)"});
        Assertions.assertThat((String)outString).contains(new CharSequence[]{"<input id=\"field_1703386699666296E12\" name=\"dateBirth\" type=\"date\" class=\"form-control\" value="});
    }

    @Test
    public void testProcessFormRendererWithDateTime() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/dateTime-local-form.json"));
        ProcessAssetDesc processAssetDesc = new ProcessAssetDesc();
        processAssetDesc.setId("test-id");
        BootstrapFormRenderer bootstrapFormRenderer = new BootstrapFormRenderer();
        String outString = bootstrapFormRenderer.renderProcess("test-containerId", (ProcessDefinition)processAssetDesc, form);
        Assertions.assertThat((String)outString).contains(new CharSequence[]{"getDate('field_1703386699666296E12',getFormattedLocalDateTime)"});
        Assertions.assertThat((String)outString).contains(new CharSequence[]{"<input id=\"field_1703386699666296E12\" name=\"dateBirth\" type=\"datetime-local\" class=\"form-control\" value="});
    }

    @Test
    public void testProcessFormRendererWithSupportedDateType() {
        FormReader reader = new FormReader();
        FormInstance form = reader.readFromStream(this.getClass().getResourceAsStream("/date-type-check-form.json"));
        ProcessAssetDesc processAssetDesc = new ProcessAssetDesc();
        processAssetDesc.setId("test-id");
        BootstrapFormRenderer bootstrapFormRenderer = new BootstrapFormRenderer();
        String outString = bootstrapFormRenderer.renderProcess("test-containerId", (ProcessDefinition)processAssetDesc, form);
        Assertions.assertThat((String)outString).contains(new CharSequence[]{"'utildate' : getDate('field_6682',getFormattedUtilDate)"});
        Assertions.assertThat((String)outString).contains(new CharSequence[]{"'localdate' : getDate('field_1147',getFormattedLocalDate)"});
        Assertions.assertThat((String)outString).contains(new CharSequence[]{"'localdatetime' : getDate('field_778156',getFormattedLocalDateTime)"});
        Assertions.assertThat((String)outString).contains(new CharSequence[]{"'localtime' : getDate('field_032',getFormattedLocalTime)"});
        Assertions.assertThat((String)outString).contains(new CharSequence[]{"'offsetdatetime' : getDate('field_9077',getFormattedOffsetDateTime)"});
    }
}

