/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.json.DataSetLookupJSONMarshaller;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonBoolean;
import org.dashbuilder.json.JsonFactory;
import org.dashbuilder.json.JsonNull;
import org.dashbuilder.json.JsonNumber;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonString;
import org.dashbuilder.json.JsonValue;
import org.junit.Assert;
import org.junit.Test;

public class DataSetLookupJsonTest {
    DataSetLookupJSONMarshaller jsonMarshaller = DataSetLookupJSONMarshaller.get();

    @Test
    public void testDataSetLookupMarshalling() {
        DataSetLookup original = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("mydataset")).filter(new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.notEqualsTo((String)"department", (Comparable)((Object)"IT")), FilterFactory.greaterOrEqualsTo((String)"amount", (Comparable)Double.valueOf(100.0))})})).filter("department", new ColumnFilter[]{FilterFactory.notEqualsTo((Comparable)((Object)"IT"))})).filter("amount", new ColumnFilter[]{FilterFactory.between((Comparable)Double.valueOf(100.0), (Comparable)Double.valueOf(200.0))})).filter("date", new ColumnFilter[]{FilterFactory.greaterThan((Comparable)this.jsonMarshaller.parseDate("2018-01-01 00:00:00"))})).filter("country", new ColumnFilter[]{FilterFactory.isNull()})).group("department")).select(new String[]{"Services"})).group("date", "year")).dynamic(DateIntervalType.YEAR, true)).column("date")).column("amount", AggregateFunctionType.SUM, "total")).sort("date", SortOrder.ASCENDING)).buildLookup();
        JsonObject _jsonObj = this.jsonMarshaller.toJson(original);
        Assert.assertNotNull((Object)_jsonObj.toString());
        DataSetLookup unmarshalled = this.jsonMarshaller.fromJson(_jsonObj);
        Assert.assertEquals((Object)unmarshalled, (Object)original);
    }

    @Test
    public void testDateFormat() {
        String d1 = "2020-11-10 23:59:59";
        Date d2 = this.jsonMarshaller.parseDate(d1);
        String d3 = this.jsonMarshaller.formatDate(d2);
        Assert.assertEquals((Object)d1, (Object)d3);
        d1 = "2020-01-01 00:00:00";
        d2 = this.jsonMarshaller.parseDate(d1);
        d3 = this.jsonMarshaller.formatDate(d2);
        Assert.assertEquals((Object)d1, (Object)d3);
    }

    @Test
    public void test_DASHBUILDE_83() {
        JsonValue jsonNull = this.jsonMarshaller.formatValue(null);
        JsonValue jsonBoolean = this.jsonMarshaller.formatValue((Object)true);
        JsonValue jsonNumber = this.jsonMarshaller.formatValue((Object)100.0);
        JsonValue jsonDate = this.jsonMarshaller.formatValue((Object)new Date());
        JsonValue jsonString = this.jsonMarshaller.formatValue((Object)"string");
        Assert.assertTrue((boolean)(jsonNull instanceof JsonNull));
        Assert.assertTrue((boolean)(jsonBoolean instanceof JsonBoolean));
        Assert.assertTrue((boolean)(jsonNumber instanceof JsonNumber));
        Assert.assertTrue((boolean)(jsonDate instanceof JsonString));
        Assert.assertTrue((boolean)(jsonString instanceof JsonString));
    }

    @Test
    public void testFormatColumnFilter() {
        CoreFunctionFilter columnFilter = new CoreFunctionFilter();
        columnFilter.setColumnId("test_id");
        columnFilter.setLabelValue("test_label_value");
        columnFilter.setType(CoreFunctionType.EQUALS_TO);
        columnFilter.setParameters(Arrays.asList("param0", "param1", "param2"));
        JsonObject columnFilterJsonObject = this.jsonMarshaller.formatColumnFilter((ColumnFilter)columnFilter);
        this.assertColumnFilterFromJsonObject(columnFilterJsonObject);
        LogicalExprFilter logicalExprFilter = new LogicalExprFilter();
        logicalExprFilter.setColumnId("test_id");
        logicalExprFilter.setLogicalOperator(LogicalExprType.AND);
        logicalExprFilter.setLogicalTerms(Arrays.asList(columnFilter));
        JsonObject logicalExprFilterJsonObject = this.jsonMarshaller.formatColumnFilter((ColumnFilter)logicalExprFilter);
        Assert.assertEquals((Object)"test_id", (Object)logicalExprFilterJsonObject.getString("column"));
        Assert.assertEquals((Object)"AND", (Object)logicalExprFilterJsonObject.getString("function"));
        this.assertColumnFilterFromJsonObject((JsonObject)logicalExprFilterJsonObject.getArray("args").get(0));
    }

    private void assertColumnFilterFromJsonObject(JsonObject columnFilterJsonObject) {
        Assert.assertEquals((Object)"test_label_value", (Object)columnFilterJsonObject.getString("labelValue"));
        Assert.assertEquals((Object)"test_id", (Object)columnFilterJsonObject.getString("column"));
        Assert.assertEquals((Object)"EQUALS_TO", (Object)columnFilterJsonObject.getString("function"));
        JsonArray columnFilterJsonArray = columnFilterJsonObject.getArray("args");
        for (int i = 0; i < columnFilterJsonArray.length(); ++i) {
            Assert.assertEquals((Object)("param" + i), (Object)columnFilterJsonArray.get(i).asString());
        }
    }

    @Test
    public void testParseColumnFilter() {
        JsonFactory jsonFactory = new JsonFactory();
        JsonObject coreFunctionFilterJsonObject = (JsonObject)jsonFactory.parse("{\n  \"column\": \"test_id\",\n  \"function\": \"EQUALS_TO\",\n  \"labelValue\": \"test_label_value\",\n  \"args\": [\n    \"param0\",\n    \"param1\",\n    \"param2\"\n  ]\n}");
        CoreFunctionFilter coreFunctionFilter = (CoreFunctionFilter)this.jsonMarshaller.parseColumnFilter(coreFunctionFilterJsonObject);
        this.assertColumnFilterFromColumnFilter(coreFunctionFilter);
        JsonObject logicalExprFilterJsonObject = (JsonObject)jsonFactory.parse("{\n  \"column\": \"test_id\",\n  \"function\": \"AND\",\n  \"args\": [\n    {\n      \"column\": \"test_id\",\n      \"function\": \"EQUALS_TO\",\n      \"labelValue\": \"test_label_value\",\n      \"args\": [\n        \"param0\",\n        \"param1\",\n        \"param2\"\n      ]\n    }\n  ]\n}");
        LogicalExprFilter logicalExprFilter = (LogicalExprFilter)this.jsonMarshaller.parseColumnFilter(logicalExprFilterJsonObject);
        Assert.assertEquals((Object)"test_id", (Object)logicalExprFilter.getColumnId());
        Assert.assertEquals((Object)"AND", (Object)logicalExprFilter.getLogicalOperator().toString());
        logicalExprFilter.getLogicalTerms().forEach(object -> this.assertColumnFilterFromColumnFilter((CoreFunctionFilter)object));
    }

    private void assertColumnFilterFromColumnFilter(CoreFunctionFilter coreFunctionFilter) {
        Assert.assertEquals((Object)"test_label_value", (Object)coreFunctionFilter.getLabelValue());
        Assert.assertEquals((Object)"test_id", (Object)coreFunctionFilter.getColumnId());
        Assert.assertEquals((Object)"EQUALS_TO", (Object)coreFunctionFilter.getType().toString());
        List params = coreFunctionFilter.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            Assert.assertEquals((Object)("param" + i), params.get(i));
        }
    }
}

