/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.docker.access.impl;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificateException;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.messages.Info;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.guvnor.ala.docker.access.DockerAccessInterface;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.lifecycle.Disposable;

public class DockerAccessInterfaceImpl
implements DockerAccessInterface,
Disposable {
    protected static final Logger LOG = LoggerFactory.getLogger(DockerAccessInterfaceImpl.class);
    private final Map<String, DockerClient> clientMap = new ConcurrentHashMap<String, DockerClient>();

    @Override
    public DockerClient getDockerClient(ProviderId providerId) throws DockerException, InterruptedException {
        if (!this.clientMap.containsKey(providerId.getId())) {
            this.clientMap.put(providerId.getId(), this.buildClient(providerId));
        }
        return this.clientMap.get(providerId.getId());
    }

    private DockerClient buildClient(ProviderId providerId) throws DockerException, InterruptedException {
        if (providerId.getId().equals("local")) {
            try {
                if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                    DefaultDockerClient dockerClient = DefaultDockerClient.builder().uri("unix:///var/run/docker.sock").build();
                    Info info = dockerClient.info();
                    LOG.info("Connected to Docker Client Info: " + info);
                    return dockerClient;
                }
                try {
                    DefaultDockerClient dockerClient = DefaultDockerClient.fromEnv().build();
                    Info info = dockerClient.info();
                    LOG.info("Connected to Docker Client Info: " + info);
                    return dockerClient;
                }
                catch (DockerCertificateException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (DockerException | InterruptedException ex) {
                try {
                    DefaultDockerClient dockerClient = DefaultDockerClient.fromEnv().build();
                    Info info = dockerClient.info();
                    LOG.info("Connected to Docker Client Info: " + info);
                    return dockerClient;
                }
                catch (DockerCertificateException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new RuntimeException("Couldn't create Docker Client, for providerId = " + providerId.getId());
    }

    public void dispose() {
        this.clientMap.values().forEach(DockerClient::close);
    }
}

