/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.docker.config.impl;

import org.guvnor.ala.config.CloneableConfig;
import org.guvnor.ala.docker.config.DockerRuntimeConfig;
import org.guvnor.ala.runtime.providers.ProviderId;

public class DockerRuntimeConfigImpl
implements DockerRuntimeConfig,
CloneableConfig<DockerRuntimeConfig> {
    private String runtimeName;
    private String image;
    private String port;
    private boolean pull;
    private ProviderId providerId;

    public DockerRuntimeConfigImpl() {
    }

    public DockerRuntimeConfigImpl(ProviderId providerId, String image, String port, boolean pull) {
        this.providerId = providerId;
        this.image = image;
        this.port = port;
        this.pull = pull;
        this.runtimeName = image;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public boolean isPull() {
        return this.pull;
    }

    public ProviderId getProviderId() {
        return this.providerId;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setPull(boolean pull) {
        this.pull = pull;
    }

    public void setProviderId(ProviderId providerId) {
        this.providerId = providerId;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public String toString() {
        return "DockerRuntimeConfigImpl{image=" + this.image + ", port=" + this.port + ", pull=" + this.pull + ", providerId=" + this.providerId + '}';
    }

    public DockerRuntimeConfig asNewClone(DockerRuntimeConfig source) {
        return new DockerRuntimeConfigImpl(source.getProviderId(), source.getImage(), source.getPort(), source.isPull());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerRuntimeConfigImpl that = (DockerRuntimeConfigImpl)o;
        if (this.pull != that.pull) {
            return false;
        }
        if (this.runtimeName != null ? !this.runtimeName.equals(that.runtimeName) : that.runtimeName != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        return this.providerId != null ? this.providerId.equals(that.providerId) : that.providerId == null;
    }

    public int hashCode() {
        int result = this.runtimeName != null ? this.runtimeName.hashCode() : 0;
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.pull ? 1 : 0);
        result = 31 * result + (this.providerId != null ? this.providerId.hashCode() : 0);
        return result;
    }
}

