/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedContext;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.kie.workbench.ala.openshift.jackson.databind.ObjectMapper;
import org.kie.workbench.ala.openshift.jackson.dataformat.yaml.YAMLFactory;

public class KubeConfigUtils {
    public static Config parseConfig(File file) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        return mapper.readValue(file, Config.class);
    }

    public static Config parseConfigFromString(String contents) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        return mapper.readValue(contents, Config.class);
    }

    public static Context getCurrentContext(Config config) {
        List<NamedContext> contexts;
        String contextName = config.getCurrentContext();
        if (contextName != null && (contexts = config.getContexts()) != null) {
            for (NamedContext context : contexts) {
                if (!contextName.equals(context.getName())) continue;
                return context.getContext();
            }
        }
        return null;
    }

    public static String getUserToken(Config config, Context context) {
        AuthInfo authInfo = KubeConfigUtils.getUserAuthInfo(config, context);
        if (authInfo != null) {
            return authInfo.getToken();
        }
        return null;
    }

    public static AuthInfo getUserAuthInfo(Config config, Context context) {
        List<NamedAuthInfo> users;
        String user;
        AuthInfo authInfo = null;
        if (config != null && context != null && (user = context.getUser()) != null && (users = config.getUsers()) != null) {
            for (NamedAuthInfo namedAuthInfo : users) {
                if (!user.equals(namedAuthInfo.getName())) continue;
                authInfo = namedAuthInfo.getUser();
            }
        }
        return authInfo;
    }

    public static Cluster getCluster(Config config, Context context) {
        List<NamedCluster> clusters;
        String clusterName;
        Cluster cluster = null;
        if (config != null && context != null && (clusterName = context.getCluster()) != null && (clusters = config.getClusters()) != null) {
            for (NamedCluster namedCluster : clusters) {
                if (!clusterName.equals(namedCluster.getName())) continue;
                cluster = namedCluster.getCluster();
            }
        }
        return cluster;
    }
}

