/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.backend.handler;

import java.util.HashMap;
import org.guvnor.ala.openshift.config.OpenShiftProperty;
import org.guvnor.ala.openshift.config.OpenShiftProviderConfig;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.openshift.backend.handler.OpenShiftProviderConfigConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class OpenShiftProviderConfigConverterTest {
    private static final String PROVIDER_NAME_VALUE = "PROVIDER_NAME_VALUE";
    private static final String MAIN_URL_VALUE = "MAIN_URL_VALUE";
    private static final String USER_VALUE = "USER_VALUE";
    private static final String PASSWORD_VALUE = "PASSWORD_VALUE";
    private OpenShiftProviderConfigConverter converter;

    @Before
    public void setUp() {
        this.converter = new OpenShiftProviderConfigConverter();
    }

    @Test
    public void testToDomain() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(OpenShiftProperty.KUBERNETES_MAIN.inputKey(), MAIN_URL_VALUE);
        values.put(OpenShiftProperty.KUBERNETES_AUTH_BASIC_USERNAME.inputKey(), USER_VALUE);
        values.put(OpenShiftProperty.KUBERNETES_AUTH_BASIC_PASSWORD.inputKey(), PASSWORD_VALUE);
        ProviderConfiguration configuration = new ProviderConfiguration(PROVIDER_NAME_VALUE, values);
        OpenShiftProviderConfig result = this.converter.toDomain(configuration);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)PROVIDER_NAME_VALUE, (Object)result.getName());
        Assert.assertEquals((Object)MAIN_URL_VALUE, (Object)result.getKubernetesMain());
        Assert.assertEquals((Object)USER_VALUE, (Object)result.getKubernetesAuthBasicUsername());
        Assert.assertEquals((Object)PASSWORD_VALUE, (Object)result.getKubernetesAuthBasicPassword());
    }

    @Test
    public void testToDomainNull() {
        Assert.assertNull((Object)this.converter.toDomain(null));
    }

    @Test
    public void testToModel() {
        OpenShiftProviderConfig config = (OpenShiftProviderConfig)Mockito.mock(OpenShiftProviderConfig.class);
        Mockito.when((Object)config.getName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        Mockito.when((Object)config.getKubernetesMain()).thenReturn((Object)MAIN_URL_VALUE);
        Mockito.when((Object)config.getKubernetesAuthBasicUsername()).thenReturn((Object)USER_VALUE);
        Mockito.when((Object)config.getKubernetesAuthBasicPassword()).thenReturn((Object)PASSWORD_VALUE);
        ProviderConfiguration result = this.converter.toModel(config);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)PROVIDER_NAME_VALUE, (Object)result.getId());
        Assert.assertEquals((Object)MAIN_URL_VALUE, result.getValues().get(OpenShiftProperty.KUBERNETES_MAIN.inputKey()));
        Assert.assertEquals((Object)USER_VALUE, result.getValues().get(OpenShiftProperty.KUBERNETES_AUTH_BASIC_USERNAME.inputKey()));
        Assert.assertEquals((Object)PASSWORD_VALUE, result.getValues().get(OpenShiftProperty.KUBERNETES_AUTH_BASIC_PASSWORD.inputKey()));
    }

    @Test
    public void testToModelNull() {
        Assert.assertNull((Object)this.converter.toModel(null));
    }
}

