/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.backend.service;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.ui.openshift.backend.service.OpenShiftClientServiceImpl;
import org.guvnor.ala.ui.openshift.model.DefaultSettings;
import org.guvnor.ala.ui.openshift.model.TemplateDescriptorModel;
import org.guvnor.ala.ui.openshift.model.TemplateParam;
import org.guvnor.ala.ui.openshift.service.OpenShiftClientService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class OpenShiftClientServiceImplTest {
    private static final String DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE = "DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE";
    private static final String DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE = "DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE";
    private static final String DEFAULT_OPEN_SHIFT_SECRETS_VALUE = "DEFAULT_OPEN_SHIFT_SECRETS_VALUE";
    private static final String TEMPLATE = "org/guvnor/ala/ui/openshift/backend/service/openshift-client-service-test.json";
    private static final int PARAMS_COUNT = 5;
    private OpenShiftClientService service;

    @Before
    public void setUp() {
        this.service = new OpenShiftClientServiceImpl();
    }

    @Test
    public void testGetDefaultSettings() {
        System.getProperties().setProperty("org.kie.provisioning.openshift.defaultTemplate", DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE);
        System.getProperties().setProperty("org.kie.provisioning.openshift.defaultImageStreams", DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE);
        System.getProperties().setProperty("org.kie.provisioning.openshift.defaultSecrets", DEFAULT_OPEN_SHIFT_SECRETS_VALUE);
        DefaultSettings defaultSettings = this.service.getDefaultSettings();
        Assert.assertEquals((Object)DEFAULT_OPEN_SHIFT_TEMPLATE_VALUE, (Object)defaultSettings.getValue("org.kie.provisioning.openshift.defaultTemplate"));
        Assert.assertEquals((Object)DEFAULT_OPEN_SHIFT_IMAGE_STREAMS_VALUE, (Object)defaultSettings.getValue("org.kie.provisioning.openshift.defaultImageStreams"));
        Assert.assertEquals((Object)DEFAULT_OPEN_SHIFT_SECRETS_VALUE, (Object)defaultSettings.getValue("org.kie.provisioning.openshift.defaultSecrets"));
    }

    @Test
    public void testGetTemplateModel() throws Exception {
        String url = this.getClass().getClassLoader().getResource(TEMPLATE).toString();
        TemplateDescriptorModel model = this.service.getTemplateModel(url);
        List<TemplateParam> expectedParams = this.buildExpectedParams(5);
        Assert.assertEquals(expectedParams, (Object)model.getParams());
    }

    private List<TemplateParam> buildExpectedParams(int count) {
        ArrayList<TemplateParam> params = new ArrayList<TemplateParam>();
        for (int i = 0; i < count; ++i) {
            String name = String.format("PARAM%d", i);
            String displayName = String.format("PARAM%d display name", i);
            String description = String.format("PARAM%d description", i);
            boolean required = i % 2 == 0;
            String value = String.format("PARAM%d value", i);
            params.add(new TemplateParam(name, displayName, description, required, value));
        }
        return params;
    }
}

