/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.provisioning.source.git;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.registry.inmemory.InMemorySourceRegistry;
import org.guvnor.ala.source.git.config.GitConfig;
import org.guvnor.ala.source.git.config.impl.GitConfigImpl;
import org.guvnor.ala.source.git.executor.GitConfigExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CloneTestJUnitTest {
    private File tempPath;
    private String gitUrl;

    @Before
    public void setUp() throws Exception {
        this.tempPath = Files.createTempDirectory("xxx", new FileAttribute[0]).toFile();
        File repo = new File(this.tempPath, "repo");
        Files.createDirectory(repo.toPath(), new FileAttribute[0]);
        Git.init().setDirectory(repo).call();
        this.gitUrl = "file://" + repo.getAbsolutePath();
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Test
    public void hello() throws Exception {
        String repoName = "drools-workshop-build";
        Optional source = new GitConfigExecutor((SourceRegistry)new InMemorySourceRegistry()).apply((GitConfig)new GitConfigImpl(this.tempPath.getAbsolutePath(), "master", this.gitUrl, "drools-workshop-build", "true"));
        Assert.assertTrue((boolean)source.isPresent());
        String targetRepoDir = this.tempPath.getAbsolutePath() + "/" + "drools-workshop-build" + ".git";
        Git git = Git.open((File)new File(targetRepoDir));
        Assert.assertNotNull((Object)git.getRepository().exactRef("HEAD"));
    }
}

