/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.provisioning.source.git;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.guvnor.ala.source.Source;
import org.guvnor.ala.source.git.GitRepository;
import org.guvnor.ala.source.git.UFLocal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystems;

public class UFLocalTestJUnitTest {
    private File tempPath;

    @Before
    public void setUp() {
        try {
            this.tempPath = Files.createTempDirectory("xxx", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Test
    public void sourceCloneTest() throws Exception {
        URI uri = URI.create("git://tempx");
        FileSystem fs = FileSystems.newFileSystem((URI)uri, (Map)new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
                this.put("internal", Boolean.TRUE);
                this.put("out-dir", UFLocalTestJUnitTest.this.tempPath.getAbsolutePath());
            }
        });
        UFLocal local = new UFLocal();
        GitRepository repository = (GitRepository)local.getRepository("tempx", Collections.emptyMap());
        Source source = repository.getSource("main", new String[0]);
        Assert.assertNotNull((Object)source);
        Assert.assertEquals((Object)source.getPath().getFileSystem(), (Object)fs);
    }
}

