/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.migration.cli;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.commons.cli.ParseException;
import org.kie.workbench.common.migration.cli.MigrationTool;
import org.kie.workbench.common.migration.cli.RealSystemAccess;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.ToolConfig;

public class MigrationApp {
    private List<MigrationTool> migrationTools = new ArrayList<MigrationTool>();
    private SystemAccess system = new RealSystemAccess();
    private ToolConfig toolConfig;

    public MigrationApp(String[] args) {
        this.toolConfig = this.parseToolConfigOrExit(args);
        ServiceLoader<MigrationTool> migrationLoader = ServiceLoader.load(MigrationTool.class);
        migrationLoader.forEach(migrationTool -> this.migrationTools.add((MigrationTool)migrationTool));
        Collections.sort(this.migrationTools, Comparator.comparing(MigrationTool::getPriority));
    }

    public void start() {
        this.validateTarget();
        if (this.toolConfig.isBatch()) {
            this.runBatch();
        } else {
            this.printWizard();
        }
    }

    private void printWizard() {
        String response;
        Integer n;
        Object tool;
        this.system.out().println("\n");
        this.system.out().println("Kie Workbench Migration Tool");
        this.system.out().println("============================\n");
        SystemAccess.Console console = this.system.console();
        HashMap<String, Runnable> menuOptions = new HashMap<String, Runnable>();
        Integer index = 1;
        while (index <= this.migrationTools.size()) {
            tool = this.migrationTools.get(index - 1);
            console.format("%s) %s (%s)\n", index, tool.getTitle().toUpperCase(), tool.getDescription());
            menuOptions.put(index.toString(), () -> this.lambda$printWizard$1((MigrationTool)tool));
            tool = index;
            n = index = Integer.valueOf(index + 1);
        }
        console.format("%s) ALL\n", index);
        menuOptions.put(index.toString(), () -> this.execute(this.migrationTools.toArray(new MigrationTool[this.migrationTools.size()])));
        tool = index;
        n = index = Integer.valueOf(index + 1);
        console.format("%s) EXIT\n\n", index);
        menuOptions.put(index.toString(), this::exit);
        while (!menuOptions.containsKey(response = console.readLine("Choose one option [1-" + index + "]: ", new Object[0]).toLowerCase())) {
        }
        ((Runnable)menuOptions.get(response)).run();
    }

    private void runBatch() {
        this.execute(this.migrationTools.toArray(new MigrationTool[this.migrationTools.size()]));
    }

    private void execute(MigrationTool ... tools) {
        for (MigrationTool tool : tools) {
            tool.run(this.toolConfig, this.system);
        }
        if (!this.toolConfig.isBatch()) {
            this.printWizard();
        }
    }

    private void exit() {
        this.system.out().println("\nGoodbye!");
        this.system.exit(0);
    }

    private ToolConfig parseToolConfigOrExit(String[] args) {
        ToolConfig.DefaultFactory configFactory = new ToolConfig.DefaultFactory();
        ToolConfig config = null;
        try {
            config = configFactory.parse(args);
        }
        catch (ParseException e) {
            this.system.err().printf("Could not parse arguments: %s\n", e.getMessage());
            configFactory.printHelp(this.system.err(), "migration-tool");
            this.system.exit(1);
        }
        return config;
    }

    private void validateTarget() {
        Path niogitDir = this.toolConfig.getTarget();
        Optional<String> errorMessage = Optional.empty();
        try {
            File dirFile = niogitDir.toFile();
            if (!dirFile.exists()) {
                errorMessage = Optional.of(String.format("The target path does not exist: %s", niogitDir));
            } else if (!dirFile.isDirectory()) {
                errorMessage = Optional.of(String.format("The target path is not a directory: %s", niogitDir));
            }
        }
        catch (UnsupportedOperationException e) {
            errorMessage = Optional.of(String.format("The target path must be a file: %s", niogitDir));
        }
        errorMessage.ifPresent(msg -> {
            this.system.err().println((String)msg);
            this.system.exit(1);
        });
    }

    private /* synthetic */ void lambda$printWizard$1(MigrationTool tool) {
        this.execute(tool);
    }
}

