/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.migration.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Formatter;
import java.util.Scanner;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.migration.cli.SystemAccess;

@ApplicationScoped
public class RealSystemAccess
implements SystemAccess {
    @Override
    public void exit(int status) {
        System.exit(status);
    }

    @Override
    public SystemAccess.Console console() {
        return new SystemAccess.Console(){
            final Formatter formatter = new Formatter(System.out);

            @Override
            public void format(String fmt, Object ... args) {
                this.formatter.format(fmt, args);
            }

            @Override
            public String readLine(String promptFmt, Object ... args) {
                this.formatter.format(promptFmt, args);
                Scanner scanner = new Scanner(System.in);
                return scanner.nextLine();
            }
        };
    }

    @Override
    public PrintStream err() {
        return System.err;
    }

    @Override
    public PrintStream out() {
        return System.out;
    }

    @Override
    public void setProperty(String name, String value) {
        System.setProperty(name, value);
    }

    @Override
    public Path move(Path source, Path target, CopyOption ... options) throws IOException {
        return Files.move(source, target, options);
    }

    @Override
    public Path createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        return Files.createDirectory(dir, attrs);
    }
}

