/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.forms.fields.shared.MultipleValueFieldProvider;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.BasicTypeFieldProvider;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.AbstractMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.MultipleSelectorFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.BooleanMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.CharacterMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.DateMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.DecimalMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.IntegerMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.StringMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.model.FieldType;
import org.kie.workbench.common.forms.model.TypeInfo;
import org.kie.workbench.common.forms.model.TypeKind;

@Dependent
public class MultipleSelectorProvider
extends BasicTypeFieldProvider<AbstractMultipleSelectorFieldDefinition>
implements MultipleValueFieldProvider<AbstractMultipleSelectorFieldDefinition> {
    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    protected void doRegisterFields() {
        this.registerPropertyType(BigInteger.class);
        this.registerPropertyType(Byte.class);
        this.registerPropertyType(Integer.class);
        this.registerPropertyType(Long.class);
        this.registerPropertyType(Short.class);
        this.registerPropertyType(BigDecimal.class);
        this.registerPropertyType(Double.class);
        this.registerPropertyType(Float.class);
        this.registerPropertyType(Date.class);
        this.registerPropertyType("java.time.LocalDate");
        this.registerPropertyType("java.time.LocalDateTime");
        this.registerPropertyType("java.time.LocalTime");
        this.registerPropertyType("java.time.OffsetDateTime");
        this.registerPropertyType(Character.class);
        this.registerPropertyType(String.class);
        this.registerPropertyType(Boolean.class);
    }

    @Override
    public AbstractMultipleSelectorFieldDefinition createFieldByType(TypeInfo typeInfo) {
        if (typeInfo.getType().equals((Object)TypeKind.BASE) && typeInfo.isMultiple()) {
            if (typeInfo.getClassName().equals(String.class.getName())) {
                return new StringMultipleSelectorFieldDefinition();
            }
            if (typeInfo.getClassName().equals(Boolean.class.getName())) {
                return new BooleanMultipleSelectorFieldDefinition();
            }
            if (typeInfo.getClassName().equals(Character.class.getName())) {
                return new CharacterMultipleSelectorFieldDefinition();
            }
            if (typeInfo.getClassName().equals(BigInteger.class.getName()) || typeInfo.getClassName().equals(Byte.class.getName()) || typeInfo.getClassName().equals(Integer.class.getName()) || typeInfo.getClassName().equals(Long.class.getName()) || typeInfo.getClassName().equals(Short.class.getName())) {
                return new IntegerMultipleSelectorFieldDefinition();
            }
            if (typeInfo.getClassName().equals(BigDecimal.class.getName()) || typeInfo.getClassName().equals(Double.class.getName()) || typeInfo.getClassName().equals(Float.class.getName())) {
                return new DecimalMultipleSelectorFieldDefinition();
            }
            if (typeInfo.getClassName().equals(Date.class.getName()) || typeInfo.getClassName().equals("java.time.LocalDate") || typeInfo.getClassName().equals("java.time.LocalDateTime") || typeInfo.getClassName().equals("java.time.LocalTime") || typeInfo.getClassName().equals("java.time.OffsetDateTime")) {
                return new DateMultipleSelectorFieldDefinition();
            }
        }
        return null;
    }

    @Override
    public Class<? extends FieldType> getFieldType() {
        return MultipleSelectorFieldType.class;
    }

    @Override
    public String getFieldTypeName() {
        return MultipleSelectorFieldType.NAME;
    }

    @Override
    public AbstractMultipleSelectorFieldDefinition getDefaultField() {
        return new StringMultipleSelectorFieldDefinition();
    }

    @Override
    public boolean isSupported(TypeInfo typeInfo) {
        if (!typeInfo.getType().equals((Object)TypeKind.BASE) || !typeInfo.isMultiple()) {
            return false;
        }
        return super.isSupported(typeInfo);
    }
}

